/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import javax.swing.SwingUtilities;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.ActionCallback;
import org.jetbrains.jet.internal.com.intellij.openapi.util.SimpleTimer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.SimpleTimerTask;

public class TimedOutCallback
extends ActionCallback
implements Runnable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.ActionCallback.TimedOutCallback");
    private Throwable myAllocation;
    private String myMessage;
    private SimpleTimerTask myTask;
    private boolean myShouldDumpError;

    public TimedOutCallback(long timeOut, String message, Throwable allocation, boolean isEdt) {
        this.scheduleCheck(timeOut, message, allocation, isEdt);
    }

    public TimedOutCallback(int countToDone, long timeOut, String message, Throwable allocation, boolean isEdt) {
        super(countToDone);
        this.scheduleCheck(timeOut, message, allocation, isEdt);
    }

    private void scheduleCheck(final long timeOut, String message, Throwable allocation, final boolean isEdt) {
        this.myMessage = message;
        this.myAllocation = allocation;
        final long current = System.currentTimeMillis();
        this.myTask = SimpleTimer.getInstance().setUp(new Runnable(){

            @Override
            public void run() {
                TimedOutCallback.this.myShouldDumpError = System.currentTimeMillis() - current > timeOut;
                if (isEdt) {
                    SwingUtilities.invokeLater(TimedOutCallback.this);
                } else {
                    TimedOutCallback.this.run();
                }
            }
        }, timeOut);
    }

    @Override
    public final void run() {
        if (!this.isProcessed()) {
            this.setRejected();
            if (this.myShouldDumpError) {
                this.dumpError();
            }
            this.onTimeout();
        }
    }

    protected void dumpError() {
        if (this.myAllocation != null) {
            LOG.error(this.myMessage, this.myAllocation);
        } else {
            LOG.error(this.myMessage);
        }
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Throwable getAllocation() {
        return this.myAllocation;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTask.cancel();
    }

    protected void onTimeout() {
    }
}

