/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Segment;

public class TextRange
implements Serializable,
Segment {
    public static final TextRange EMPTY_RANGE = new TextRange(0, 0);
    private final int myStartOffset;
    private final int myEndOffset;

    public TextRange(int startOffset, int endOffset) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    @Override
    public final int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.myEndOffset;
    }

    public final int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange range = (TextRange)obj;
        return this.myStartOffset == range.myStartOffset && this.myEndOffset == range.myEndOffset;
    }

    public int hashCode() {
        return this.myStartOffset + this.myEndOffset;
    }

    public boolean contains(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.contains must not be null");
        }
        return this.containsRange(range.getStartOffset(), range.getEndOffset());
    }

    public boolean containsRange(int startOffset, int endOffset) {
        return this.myStartOffset <= startOffset && this.myEndOffset >= endOffset;
    }

    public boolean containsOffset(int offset) {
        return this.myStartOffset <= offset && offset <= this.myEndOffset;
    }

    public String toString() {
        return "(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }

    public boolean contains(int offset) {
        return this.myStartOffset <= offset && offset < this.myEndOffset;
    }

    @NotNull
    public String substring(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.substring must not be null");
        }
        String string = str.substring(this.myStartOffset, this.myEndOffset);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.substring must not return null");
        }
        return string;
    }

    @NotNull
    public TextRange cutOut(@NotNull TextRange subRange) {
        if (subRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.cutOut must not be null");
        }
        assert (subRange.getStartOffset() <= this.getLength()) : subRange + "; this=" + this;
        assert (subRange.getEndOffset() <= this.getLength()) : subRange + "; this=" + this;
        TextRange textRange = new TextRange(this.myStartOffset + subRange.getStartOffset(), Math.min(this.myEndOffset, this.myStartOffset + subRange.getEndOffset()));
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.cutOut must not return null");
        }
        return textRange;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TextRange shiftRight(int delta) {
        TextRange textRange;
        if (delta == 0) {
            textRange = this;
            if (textRange == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.shiftRight must not return null");
            return textRange;
        }
        textRange = new TextRange(this.myStartOffset + delta, this.myEndOffset + delta);
        if (textRange != null) return textRange;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.shiftRight must not return null");
    }

    @NotNull
    public TextRange grown(int lengthDelta) {
        TextRange textRange = TextRange.from(this.myStartOffset, this.getLength() + lengthDelta);
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.grown must not return null");
        }
        return textRange;
    }

    @NotNull
    public static TextRange from(int offset, int length) {
        TextRange textRange = TextRange.create(offset, offset + length);
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.from must not return null");
        }
        return textRange;
    }

    @NotNull
    public static TextRange create(int startOffset, int endOffset) {
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.create must not return null");
        }
        return textRange;
    }

    @NotNull
    public static TextRange create(@NotNull Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.create must not be null");
        }
        TextRange textRange = TextRange.create(segment.getStartOffset(), segment.getEndOffset());
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.create must not return null");
        }
        return textRange;
    }

    public static boolean areSegmentsEqual(@NotNull Segment segment1, @NotNull Segment segment2) {
        if (segment1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.areSegmentsEqual must not be null");
        }
        if (segment2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/TextRange.areSegmentsEqual must not be null");
        }
        return segment1.getStartOffset() == segment2.getStartOffset() && segment1.getEndOffset() == segment2.getEndOffset();
    }

    @NotNull
    public String replace(@NotNull String original, @NotNull String replacement) {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.replace must not be null");
        }
        if (replacement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/TextRange.replace must not be null");
        }
        String beginning = original.substring(0, this.getStartOffset());
        String ending = original.substring(this.getEndOffset(), original.length());
        String string = beginning + replacement + ending;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.replace must not return null");
        }
        return string;
    }

    public boolean intersects(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.intersects must not be null");
        }
        return this.intersects(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersects(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) <= Math.min(this.myEndOffset, endOffset);
    }

    public boolean intersectsStrict(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.intersectsStrict must not be null");
        }
        return this.intersectsStrict(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersectsStrict(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) < Math.min(this.myEndOffset, endOffset);
    }

    @Nullable
    public TextRange intersection(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.intersection must not be null");
        }
        if (!this.intersects(range)) {
            return null;
        }
        return new TextRange(Math.max(this.myStartOffset, range.getStartOffset()), Math.min(this.myEndOffset, range.getEndOffset()));
    }

    public boolean isEmpty() {
        return this.myStartOffset >= this.myEndOffset;
    }

    @NotNull
    public TextRange union(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.union must not be null");
        }
        TextRange textRange2 = new TextRange(Math.min(this.myStartOffset, textRange.getStartOffset()), Math.max(this.myEndOffset, textRange.getEndOffset()));
        if (textRange2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.union must not return null");
        }
        return textRange2;
    }

    public boolean equalsToRange(int startOffset, int endOffset) {
        return startOffset == this.myStartOffset && endOffset == this.myEndOffset;
    }

    public static TextRange allOf(String s) {
        return new TextRange(0, s.length());
    }
}

