/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Ref;
import org.jetbrains.jet.internal.com.intellij.openapi.util.SimpleTimerTask;

public class SimpleTimer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.SimpleTimer");
    private final Timer ourTimer;
    private static final SimpleTimer ourInstance = SimpleTimer.newInstance("Shared SimpleTimer");
    private long myNextScheduledTime;
    private TimerTask myNextProcessingTask;
    private final Map<Long, ArrayList<SimpleTimerTask>> myTime2Task;
    private String myThreadName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleTimer(@NotNull String threadName) {
        if (threadName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/SimpleTimer.<init> must not be null");
        }
        this.myNextScheduledTime = Long.MAX_VALUE;
        this.myTime2Task = new TreeMap<Long, ArrayList<SimpleTimerTask>>();
        this.myThreadName = threadName;
        Thread thread = Thread.currentThread();
        int currentPrio = thread.getPriority();
        try {
            thread.setPriority(2);
            this.ourTimer = new Timer(threadName, true);
        }
        finally {
            thread.setPriority(currentPrio);
        }
    }

    public static SimpleTimer getInstance() {
        return ourInstance;
    }

    public static SimpleTimer newInstance(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/SimpleTimer.newInstance must not be null");
        }
        return new SimpleTimer(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTimerTask setUp(Runnable runnable, long delay) {
        Map<Long, ArrayList<SimpleTimerTask>> map = this.myTime2Task;
        synchronized (map) {
            long current = System.currentTimeMillis();
            long targetTime = current + delay;
            SimpleTimerTask result = new SimpleTimerTask(targetTime, runnable, this);
            ArrayList<SimpleTimerTask> tasks = this.myTime2Task.get(targetTime);
            if (tasks == null) {
                tasks = new ArrayList(2);
                this.myTime2Task.put(targetTime, tasks);
            }
            tasks.add(result);
            if (targetTime < this.myNextScheduledTime) {
                if (this.myNextProcessingTask != null) {
                    this.myNextProcessingTask.cancel();
                }
                this.scheduleNext(delay, targetTime);
            }
            return result;
        }
    }

    private void scheduleNext(long delay, long targetTime) {
        this.myNextScheduledTime = targetTime;
        this.myNextProcessingTask = new TimerTask(){

            @Override
            public void run() {
                SimpleTimer.this.processNext();
            }
        };
        this.ourTimer.schedule(this.myNextProcessingTask, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNext() {
        Ref<ArrayList<SimpleTimerTask>> tasks = new Ref<ArrayList<SimpleTimerTask>>();
        Map<Long, ArrayList<SimpleTimerTask>> map = this.myTime2Task;
        synchronized (map) {
            long current = System.currentTimeMillis();
            Iterator<Long> times = this.myTime2Task.keySet().iterator();
            if (times.hasNext()) {
                Long time = times.next();
                tasks.set(this.myTime2Task.get(time));
                times.remove();
            }
            if (!times.hasNext()) {
                this.myNextScheduledTime = Long.MAX_VALUE;
                this.myNextProcessingTask = null;
            } else {
                Long nextEffectiveTime = null;
                while (times.hasNext()) {
                    Long nextTime = times.next();
                    if (nextTime <= current) {
                        ((ArrayList)tasks.get()).addAll((Collection)this.myTime2Task.get(nextTime));
                        times.remove();
                        continue;
                    }
                    nextEffectiveTime = nextTime;
                    break;
                }
                if (nextEffectiveTime == null) {
                    this.myNextProcessingTask = null;
                    this.myNextScheduledTime = Long.MAX_VALUE;
                } else {
                    this.scheduleNext(nextEffectiveTime - current, nextEffectiveTime);
                }
            }
        }
        ArrayList toRun = (ArrayList)tasks.get();
        if (toRun != null) {
            for (SimpleTimerTask each : toRun) {
                try {
                    each.run();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    public boolean isTimerThread() {
        return this.isTimerThread(Thread.currentThread());
    }

    public boolean isTimerThread(Thread thread) {
        return this.myThreadName.equals(thread.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancelled(SimpleTimerTask task) {
        Map<Long, ArrayList<SimpleTimerTask>> map = this.myTime2Task;
        synchronized (map) {
            ArrayList<SimpleTimerTask> list = this.myTime2Task.get(task.getTargetTime());
            if (list != null) {
                list.remove(task);
                if (list.size() == 0) {
                    this.myTime2Task.remove(task.getTargetTime());
                }
            }
        }
    }
}

