/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.util.concurrency.Semaphore;

public class ShutDownTracker
implements Runnable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.ShutDownTracker");
    private final List<Thread> myThreads = new ArrayList<Thread>();
    private final LinkedList<Thread> myShutdownThreads = new LinkedList();
    private final LinkedList<Runnable> myShutdownTasks = new LinkedList();
    private volatile boolean myIsShutdownHookRunning = false;

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this, "Shutdown tracker"));
    }

    public static ShutDownTracker getInstance() {
        return ShutDownTrackerHolder.ourInstance;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myIsShutdownHookRunning;
    }

    @Override
    public void run() {
        this.myIsShutdownHookRunning = true;
        this.ensureStopperThreadsFinished();
        Runnable task = this.removeLast(this.myShutdownTasks);
        while (task != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            task = this.removeLast(this.myShutdownTasks);
        }
        Thread thread = this.removeLast(this.myShutdownThreads);
        while (thread != null) {
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            thread = this.removeLast(this.myShutdownThreads);
        }
    }

    public final void ensureStopperThreadsFinished() {
        Thread[] threads = this.getStopperThreads();
        while (threads.length > 0) {
            Thread thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    LOG.error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker.");
                    this.unregisterStopperThread(thread);
                }
            } else {
                try {
                    thread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
    }

    private synchronized boolean isRegistered(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.isRegistered must not be null");
        }
        return this.myThreads.contains(thread);
    }

    @NotNull
    private synchronized Thread[] getStopperThreads() {
        Thread[] threadArray = this.myThreads.toArray(new Thread[this.myThreads.size()]);
        if (threadArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ShutDownTracker.getStopperThreads must not return null");
        }
        return threadArray;
    }

    public synchronized void registerStopperThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.registerStopperThread must not be null");
        }
        this.myThreads.add(thread);
    }

    public synchronized void unregisterStopperThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.unregisterStopperThread must not be null");
        }
        this.myThreads.remove(thread);
    }

    public synchronized void registerShutdownThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.registerShutdownThread must not be null");
        }
        this.myShutdownThreads.addLast(thread);
    }

    public synchronized void registerShutdownThread(int index, @NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.registerShutdownThread must not be null");
        }
        this.myShutdownThreads.add(index, thread);
    }

    public synchronized void registerShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.registerShutdownTask must not be null");
        }
        this.myShutdownTasks.addLast(task);
    }

    public synchronized void unregisterShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.unregisterShutdownTask must not be null");
        }
        this.myShutdownTasks.remove(task);
    }

    @Nullable
    private synchronized <T> T removeLast(LinkedList<T> list) {
        return list.isEmpty() ? null : (T)list.removeLast();
    }

    public static void invokeAndWait(boolean timed, boolean edt, final Runnable runnable) {
        if (!edt) {
            if (!timed) {
                runnable.run();
            }
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    semaphore.up();
                }
            }).start();
            semaphore.waitFor(1000L);
            return;
        }
        if (timed) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    semaphore.up();
                }
            });
            semaphore.waitFor(1000L);
            return;
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    private static class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();

        private ShutDownTrackerHolder() {
        }
    }
}

