/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Computable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.jet.internal.com.intellij.reference.SoftReference;
import org.jetbrains.jet.internal.com.intellij.util.containers.SoftHashMap;
import org.jetbrains.jet.internal.gnu.trove.THashMap;
import org.jetbrains.jet.internal.gnu.trove.THashSet;

public class RecursionManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.RecursionManager");
    private static final Object NULL = new Object();
    private static final ThreadLocal<CalculationStack> ourStack = new ThreadLocal<CalculationStack>(){

        @Override
        protected CalculationStack initialValue() {
            return new CalculationStack();
        }
    };

    @Nullable
    public static <T> T doPreventingRecursion(@NotNull Object key, boolean memoize, Computable<T> computation) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/RecursionManager.doPreventingRecursion must not be null");
        }
        return RecursionManager.createGuard(computation.getClass().getName()).doPreventingRecursion(key, memoize, computation);
    }

    public static RecursionGuard createGuard(final @NonNls String id) {
        return new RecursionGuard(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T doPreventingRecursion(@NotNull Object key, boolean memoize, Computable<T> computation) {
                Object o;
                if (key == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/RecursionManager$2.doPreventingRecursion must not be null");
                }
                MyKey realKey = new MyKey(id, key);
                CalculationStack stack = (CalculationStack)ourStack.get();
                if (stack.checkReentrancy(realKey)) {
                    return null;
                }
                if (memoize && (o = stack.getMemoizedValue(realKey)) != null) {
                    SoftHashMap map = (SoftHashMap)stack.intermediateCache.get(realKey);
                    if (map != null) {
                        for (MyKey noCacheUntil : map.keySet()) {
                            stack.prohibitResultCaching(noCacheUntil);
                        }
                    }
                    return (T)(o == NULL ? null : o);
                }
                int oldHash = realKey.hashCode();
                int sizeBefore = stack.progressMap.size();
                stack.beforeComputation(realKey);
                int sizeAfter = stack.progressMap.size();
                int startStamp = stack.memoizationStamp;
                try {
                    T result = computation.compute();
                    if (memoize) {
                        stack.maybeMemoize(realKey, result == null ? NULL : result, startStamp);
                    }
                    T t = result;
                    return t;
                }
                finally {
                    try {
                        stack.afterComputation(realKey, sizeBefore, sizeAfter);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Throwable in afterComputation", e);
                    }
                    stack.checkDepth("4");
                    if (oldHash != realKey.hashCode()) {
                        throw new AssertionError((Object)("Object has changed its hashCode: " + key));
                    }
                }
            }

            @Override
            public RecursionGuard.StackStamp markStack() {
                final int stamp = ((CalculationStack)ourStack.get()).reentrancyCount;
                return new RecursionGuard.StackStamp(){

                    @Override
                    public boolean mayCacheNow() {
                        return stamp == ((CalculationStack)ourStack.get()).reentrancyCount;
                    }
                };
            }

            @Override
            public List<Object> currentStack() {
                ArrayList<Object> result = new ArrayList<Object>();
                LinkedHashMap map = ((CalculationStack)ourStack.get()).progressMap;
                for (MyKey pair : map.keySet()) {
                    if (!((String)pair.first).equals(id)) continue;
                    result.add(pair.second);
                }
                return result;
            }

            @Override
            public void prohibitResultCaching(Object since) {
                MyKey realKey = new MyKey(id, since);
                CalculationStack stack = (CalculationStack)ourStack.get();
                stack.enableMemoization(realKey, stack.prohibitResultCaching(realKey));
                stack.memoizationStamp++;
            }
        };
    }

    private static class CalculationStack {
        private int reentrancyCount;
        private int memoizationStamp;
        private int depth;
        private final LinkedHashMap<MyKey, Integer> progressMap = new LinkedHashMap();
        private final Set<MyKey> toMemoize = new THashSet<MyKey>();
        private final THashMap<MyKey, MyKey> key2ReentrancyDuringItsCalculation = new THashMap();
        private final SoftHashMap<MyKey, SoftHashMap<MyKey, SoftReference>> intermediateCache = new SoftHashMap();
        private int enters = 0;
        private int exits = 0;

        private CalculationStack() {
        }

        boolean checkReentrancy(MyKey realKey) {
            if (this.progressMap.containsKey(realKey)) {
                this.enableMemoization(realKey, this.prohibitResultCaching(realKey));
                return true;
            }
            return false;
        }

        @Nullable
        Object getMemoizedValue(MyKey realKey) {
            SoftHashMap<MyKey, SoftReference> map = this.intermediateCache.get(realKey);
            if (map == null) {
                return null;
            }
            if (this.depth == 0) {
                throw new AssertionError((Object)"Memoized values with empty stack");
            }
            for (MyKey key : map.keySet()) {
                Object result;
                SoftReference reference = map.get(key);
                if (reference == null || (result = reference.get()) == null) continue;
                return result;
            }
            return null;
        }

        final void beforeComputation(MyKey realKey) {
            ++this.enters;
            if (this.progressMap.isEmpty()) assert (this.reentrancyCount == 0) : "Non-zero stamp with empty stack: " + this.reentrancyCount;
            this.checkDepth("1");
            int sizeBefore = this.progressMap.size();
            this.progressMap.put(realKey, this.reentrancyCount);
            ++this.depth;
            this.checkDepth("2");
            int sizeAfter = this.progressMap.size();
            if (sizeAfter != sizeBefore + 1) {
                LOG.error("Key doesn't lead to the map size increase: " + sizeBefore + " " + sizeAfter + " " + realKey.second);
            }
        }

        final void maybeMemoize(MyKey realKey, @NotNull Object result, int startStamp) {
            if (result == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/RecursionManager$CalculationStack.maybeMemoize must not be null");
            }
            if (this.memoizationStamp == startStamp && this.toMemoize.contains(realKey)) {
                SoftHashMap<MyKey, SoftReference<Object>> map = this.intermediateCache.get(realKey);
                if (map == null) {
                    map = new SoftHashMap();
                    this.intermediateCache.put(realKey, map);
                }
                MyKey reentered = this.key2ReentrancyDuringItsCalculation.get(realKey);
                assert (reentered != null);
                map.put(reentered, new SoftReference<Object>(result));
            }
        }

        final void afterComputation(MyKey realKey, int sizeBefore, int sizeAfter) {
            ++this.exits;
            if (sizeAfter != this.progressMap.size()) {
                LOG.error("Map size changed: " + this.progressMap.size() + " " + sizeAfter + " " + realKey.second);
            }
            if (this.depth != this.progressMap.size()) {
                LOG.error("Inconsistent depth after computation; depth=" + this.depth + "; map=" + this.progressMap);
            }
            Integer value = (Integer)this.progressMap.remove(realKey);
            --this.depth;
            this.toMemoize.remove(realKey);
            this.key2ReentrancyDuringItsCalculation.remove(realKey);
            if (this.depth == 0) {
                this.intermediateCache.clear();
                LOG.assertTrue(this.key2ReentrancyDuringItsCalculation.isEmpty(), "non-empty key2ReentrancyDuringItsCalculation");
                LOG.assertTrue(this.toMemoize.isEmpty(), "non-empty toMemoize");
            }
            if (sizeBefore != this.progressMap.size()) {
                LOG.error("Map size doesn't decrease: " + this.progressMap.size() + " " + sizeBefore + " " + realKey.second);
            }
            if (value == null) {
                LOG.error(realKey.second + " has changed its equals/hashCode");
            }
            this.reentrancyCount = value;
            this.checkZero();
        }

        private void enableMemoization(MyKey realKey, Set<MyKey> loop) {
            this.toMemoize.addAll(loop);
            ArrayList<MyKey> stack = new ArrayList<MyKey>(this.progressMap.keySet());
            for (MyKey key : loop) {
                MyKey existing = this.key2ReentrancyDuringItsCalculation.get(key);
                if (existing != null && stack.indexOf(realKey) < stack.indexOf(key)) continue;
                this.key2ReentrancyDuringItsCalculation.put(key, realKey);
            }
        }

        private Set<MyKey> prohibitResultCaching(MyKey realKey) {
            ++this.reentrancyCount;
            if (!this.checkZero()) {
                throw new AssertionError((Object)"zero1");
            }
            THashSet<MyKey> loop = new THashSet<MyKey>();
            boolean inLoop = false;
            for (Map.Entry<MyKey, Integer> entry : this.progressMap.entrySet()) {
                if (inLoop) {
                    entry.setValue(this.reentrancyCount);
                    loop.add(entry.getKey());
                    continue;
                }
                if (!entry.getKey().equals(realKey)) continue;
                inLoop = true;
            }
            if (!this.checkZero()) {
                throw new AssertionError((Object)"zero2");
            }
            return loop;
        }

        private void checkDepth(String s) {
            int oldDepth = this.depth;
            if (oldDepth != this.progressMap.size()) {
                this.depth = this.progressMap.size();
                throw new AssertionError((Object)("_Inconsistent depth " + s + "; depth=" + oldDepth + "; enters=" + this.enters + "; exits=" + this.exits + "; map=" + this.progressMap));
            }
        }

        private boolean checkZero() {
            if (!this.progressMap.isEmpty() && !new Integer(0).equals(this.progressMap.get(this.progressMap.keySet().iterator().next()))) {
                LOG.error("Prisoner Zero has escaped: " + this.progressMap + "; value=" + this.progressMap.get(this.progressMap.keySet().iterator().next()));
                return false;
            }
            return true;
        }
    }

    private static class MyKey
    extends Pair<String, Object> {
        public MyKey(String first, Object second) {
            super(first, second);
        }
    }
}

