/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Segment;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;

public class ProperTextRange
extends TextRange {
    public ProperTextRange(int startOffset, int endOffset) {
        super(startOffset, endOffset);
        ProperTextRange.assertProperRange(this);
    }

    public ProperTextRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.<init> must not be null");
        }
        this(range.getStartOffset(), range.getEndOffset());
    }

    public static void assertProperRange(@NotNull Segment range) throws AssertionError {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.assertProperRange must not be null");
        }
        ProperTextRange.assertProperRange(range, "");
    }

    public static void assertProperRange(@NotNull Segment range, Object message) throws AssertionError {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.assertProperRange must not be null");
        }
        ProperTextRange.assertProperRange(range.getStartOffset(), range.getEndOffset(), message);
    }

    public static void assertProperRange(int startOffset, int endOffset, Object message) {
        assert (startOffset <= endOffset) : "Invalid range specified: (" + startOffset + "," + endOffset + "); " + message;
        assert (startOffset >= 0) : "Negative start offset: (" + startOffset + "," + endOffset + "); " + message;
    }

    @Override
    @NotNull
    public ProperTextRange cutOut(@NotNull TextRange subRange) {
        if (subRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.cutOut must not be null");
        }
        assert (subRange.getStartOffset() <= this.getLength()) : subRange + "; this=" + this;
        assert (subRange.getEndOffset() <= this.getLength()) : subRange + "; this=" + this;
        ProperTextRange properTextRange = new ProperTextRange(this.getStartOffset() + subRange.getStartOffset(), Math.min(this.getEndOffset(), this.getStartOffset() + subRange.getEndOffset()));
        if (properTextRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.cutOut must not return null");
        }
        return properTextRange;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ProperTextRange shiftRight(int delta) {
        ProperTextRange properTextRange;
        if (delta == 0) {
            properTextRange = this;
            if (properTextRange == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.shiftRight must not return null");
            return properTextRange;
        }
        properTextRange = new ProperTextRange(this.getStartOffset() + delta, this.getEndOffset() + delta);
        if (properTextRange != null) return properTextRange;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.shiftRight must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ProperTextRange grown(int lengthDelta) {
        ProperTextRange properTextRange;
        if (lengthDelta == 0) {
            properTextRange = this;
            if (properTextRange == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.grown must not return null");
            return properTextRange;
        }
        properTextRange = new ProperTextRange(this.getStartOffset(), this.getEndOffset() + lengthDelta);
        if (properTextRange != null) return properTextRange;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.grown must not return null");
    }

    @Override
    public ProperTextRange intersection(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.intersection must not be null");
        }
        ProperTextRange.assertProperRange(textRange);
        TextRange range = super.intersection(textRange);
        if (range == null) {
            return null;
        }
        return new ProperTextRange(range);
    }

    @Override
    @NotNull
    public ProperTextRange union(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.union must not be null");
        }
        ProperTextRange.assertProperRange(textRange);
        TextRange range = super.union(textRange);
        ProperTextRange properTextRange = new ProperTextRange(range);
        if (properTextRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.union must not return null");
        }
        return properTextRange;
    }

    @NotNull
    public static ProperTextRange create(@NotNull Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.create must not be null");
        }
        ProperTextRange properTextRange = new ProperTextRange(segment.getStartOffset(), segment.getEndOffset());
        if (properTextRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.create must not return null");
        }
        return properTextRange;
    }

    @NotNull
    public static ProperTextRange create(int startOffset, int endOffset) {
        ProperTextRange properTextRange = new ProperTextRange(startOffset, endOffset);
        if (properTextRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.create must not return null");
        }
        return properTextRange;
    }

    @NotNull
    public static ProperTextRange from(int offset, int length) {
        ProperTextRange properTextRange = new ProperTextRange(offset, offset + length);
        if (properTextRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.from must not return null");
        }
        return properTextRange;
    }
}

