/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.util.Function;

public class Pair<A, B> {
    public final A first;
    public final B second;
    private static final Pair EMPTY = Pair.create(null, null);

    public static <A, B> Pair<A, B> create(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public static <A, B> Function<A, Pair<A, B>> createFunction(final @Nullable B value) {
        return new Function<A, Pair<A, B>>(){

            @Override
            public Pair<A, B> fun(A a) {
                return Pair.create(a, value);
            }
        };
    }

    @Nullable
    public static <T> T getFirst(@Nullable Pair<T, ?> pair) {
        return pair != null ? (T)pair.first : null;
    }

    @Nullable
    public static <T> T getSecond(@Nullable Pair<?, T> pair) {
        return pair != null ? (T)pair.second : null;
    }

    public static <A, B> Pair<A, B> empty() {
        return EMPTY;
    }

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public final A getFirst() {
        return this.first;
    }

    public final B getSecond() {
        return this.second;
    }

    public final boolean equals(Object o) {
        return o instanceof Pair && Comparing.equal(this.first, ((Pair)o).first) && Comparing.equal(this.second, ((Pair)o).second);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "<" + this.first + "," + this.second + ">";
    }
}

