/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.jet.internal.com.intellij.util.NullableFunction;
import org.jetbrains.jet.internal.com.intellij.util.ObjectUtils;

public class NullableLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private final NullableFunction<H, T> myFunction;

    private NullableLazyKey(@NonNls String name, NullableFunction<H, T> function) {
        super(name);
        this.myFunction = function;
    }

    @Nullable
    public final T getValue(H h) {
        Object data = h.getUserData(this);
        if (data == null) {
            data = this.myFunction.fun(h);
            h.putUserData(this, (Object)(data == null ? ObjectUtils.NULL : data));
        }
        return data == ObjectUtils.NULL ? null : (T)data;
    }

    public static <T, H extends UserDataHolder> NullableLazyKey<T, H> create(@NonNls String name, NullableFunction<H, T> function) {
        return new NullableLazyKey<T, H>(name, function);
    }
}

