/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.jet.internal.com.intellij.util.NotNullFunction;

public class NotNullLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private final NotNullFunction<H, T> myFunction;

    private NotNullLazyKey(@NonNls String name, NotNullFunction<H, T> function) {
        super(name);
        this.myFunction = function;
    }

    @NotNull
    public final T getValue(H h) {
        Object data = h.getUserData(this);
        if (data == null) {
            data = this.myFunction.fun(h);
            h.putUserData(this, data);
        }
        Object t = data;
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/NotNullLazyKey.getValue must not return null");
        }
        return t;
    }

    public static <T, H extends UserDataHolder> NotNullLazyKey<T, H> create(@NonNls String name, NotNullFunction<H, T> function) {
        return new NotNullLazyKey<T, H>(name, function);
    }
}

