/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.org.jdom.Element;

public class JDOMExternalizerUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.JDOMExternalizerUtil");

    public static void writeField(Element root, @NonNls String fieldName, String value) {
        Element element = new Element("option");
        element.setAttribute("name", fieldName);
        element.setAttribute("value", value == null ? "" : value);
        root.addContent(element);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String readField(Element parent, @NonNls String fieldName, @NotNull String defaultValue) {
        String string;
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/JDOMExternalizerUtil.readField must not be null");
        }
        String val = JDOMExternalizerUtil.readField(parent, fieldName);
        if (val != null) {
            string = val;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMExternalizerUtil.readField must not return null");
            return string;
        }
        string = defaultValue;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMExternalizerUtil.readField must not return null");
    }

    @Nullable
    public static String readField(Element parent, @NonNls String fieldName) {
        List list = parent.getChildren("option");
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            String childName = element.getAttributeValue("name");
            if (!Comparing.strEqual(childName, fieldName)) continue;
            return element.getAttributeValue("value");
        }
        return null;
    }
}

