/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.org.jdom.Element;

public class JDOMExternalizer {
    private JDOMExternalizer() {
    }

    public static void write(Element root, @NonNls String name, String value) {
        Element element = new Element("setting");
        element.setAttribute("name", name);
        element.setAttribute("value", value == null ? "" : value);
        root.addContent(element);
    }

    public static void write(Element root, @NonNls String name, boolean value) {
        JDOMExternalizer.write(root, name, Boolean.toString(value));
    }

    public static void write(Element root, String name, int value) {
        JDOMExternalizer.write(root, name, Integer.toString(value));
    }

    public static boolean readBoolean(Element root, @NonNls String name) {
        return Boolean.valueOf(JDOMExternalizer.readString(root, name));
    }

    public static int readInteger(Element root, String name, int defaultValue) {
        try {
            return Integer.valueOf(JDOMExternalizer.readString(root, name));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String readString(@NonNls Element root, @NonNls String name) {
        List list = root.getChildren("setting");
        for (Object aList : list) {
            Element element = (Element)aList;
            String childName = element.getAttributeValue("name");
            if (!Comparing.strEqual(childName, name)) continue;
            return element.getAttributeValue("value");
        }
        return null;
    }

    public static void writeMap(Element root, Map<String, String> map, @NonNls @Nullable String rootName, @NonNls String entryName) {
        Element mapRoot;
        if (StringUtil.isNotEmpty(rootName)) {
            mapRoot = new Element(rootName);
            root.addContent(mapRoot);
        } else {
            mapRoot = root;
        }
        Object[] names = ArrayUtil.toStringArray(map.keySet());
        Arrays.sort(names);
        for (Object name : names) {
            Element element = new Element(entryName);
            element.setAttribute("name", (String)name);
            String value = map.get(name);
            if (value != null) {
                element.setAttribute("value", value);
            }
            mapRoot.addContent(element);
        }
    }

    public static void readMap(Element root, Map<String, String> map, @NonNls @Nullable String rootName, @NonNls String entryName) {
        Element mapRoot = StringUtil.isNotEmpty(rootName) ? root.getChild(rootName) : root;
        if (mapRoot == null) {
            return;
        }
        for (Element element : mapRoot.getChildren(entryName)) {
            String name = element.getAttributeValue("name");
            if (name == null) continue;
            String value = element.getAttributeValue("value");
            map.put(name, value);
        }
    }
}

