/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.util.ArrayList;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.DefaultJDOMExternalizer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.InvalidDataException;
import org.jetbrains.jet.internal.com.intellij.openapi.util.JDOMExternalizable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.WriteExternalException;
import org.jetbrains.jet.internal.org.jdom.Element;
import sun.reflect.Reflection;

public class JDOMExternalizableStringList
extends ArrayList<String>
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.JDOMExternalizableStringList");

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.clear();
        for (Object o : element.getChildren()) {
            int listSize;
            Element listElement = (Element)o;
            if (!"list".equals(listElement.getName())) continue;
            String sizeString = listElement.getAttributeValue("size");
            try {
                listSize = Integer.parseInt(sizeString);
            }
            catch (NumberFormatException ex) {
                throw new InvalidDataException("Size " + sizeString + " found. Must be integer!");
            }
            for (int j = 0; j < listSize; ++j) {
                this.add(null);
            }
            ClassLoader classLoader = Reflection.getCallerClass((int)2).getClassLoader();
            for (Object o1 : listElement.getChildren()) {
                Class<?> itemClass;
                Element listItemElement = (Element)o1;
                if (!"item".equals(listItemElement.getName())) {
                    throw new InvalidDataException("Unable to read list item. Unknown element found: " + listItemElement.getName());
                }
                String itemIndexString = listItemElement.getAttributeValue("index");
                String itemClassString = listItemElement.getAttributeValue("class");
                try {
                    itemClass = Class.forName(itemClassString, true, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    throw new InvalidDataException("Unable to read list item: unable to load class: " + itemClassString + " \n" + ex.getMessage());
                }
                String listItem = listItemElement.getAttributeValue("itemvalue");
                LOG.assertTrue(String.class.equals(itemClass));
                int index = Integer.parseInt(itemIndexString);
                if (index >= listSize) {
                    throw new InvalidDataException("Index out of list size: index " + index + ", size " + listSize);
                }
                this.set(index, listItem);
            }
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        int listSize = this.size();
        Element listElement = new Element("list");
        listElement.setAttribute("size", Integer.toString(listSize));
        element.addContent(listElement);
        for (int i = 0; i < listSize; ++i) {
            String listItem = (String)this.get(i);
            if (listItem == null) continue;
            Element itemElement = new Element("item");
            itemElement.setAttribute("index", Integer.toString(i));
            itemElement.setAttribute("class", listItem.getClass().getName());
            itemElement.setAttribute("itemvalue", DefaultJDOMExternalizer.filterXMLCharacters(listItem));
            listElement.addContent(itemElement);
        }
    }
}

