/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;

public class ExecutionCallback {
    private final Executed myExecuted;
    private List<Runnable> myRunnables;

    ExecutionCallback() {
        this.myExecuted = new Executed(1);
    }

    ExecutionCallback(int executedCount) {
        this.myExecuted = new Executed(executedCount);
    }

    public void setExecuted() {
        this.myExecuted.signalExecution();
        this.callback();
    }

    public boolean isExecuted() {
        return this.myExecuted.isExecuted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doWhenExecuted(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ExecutionCallback.doWhenExecuted must not be null");
        }
        ExecutionCallback executionCallback = this;
        synchronized (executionCallback) {
            if (this.myRunnables == null) {
                this.myRunnables = new ArrayList<Runnable>();
            }
            this.myRunnables.add(runnable);
        }
        this.callback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callback() {
        if (this.myExecuted.isExecuted()) {
            Runnable[] all;
            ExecutionCallback executionCallback = this;
            synchronized (executionCallback) {
                if (this.myRunnables == null) {
                    all = ArrayUtil.EMPTY_RUNNABLE_ARRAY;
                } else {
                    all = this.myRunnables.toArray(new Runnable[this.myRunnables.size()]);
                    this.myRunnables.clear();
                }
            }
            for (Runnable each : all) {
                each.run();
            }
        }
    }

    public String toString() {
        return this.myExecuted.toString();
    }

    private static class Executed {
        int myCurrentCount;
        int myCountToExecution;

        Executed(int countToExecution) {
            this.myCountToExecution = countToExecution;
        }

        void signalExecution() {
            ++this.myCurrentCount;
        }

        boolean isExecuted() {
            return this.myCurrentCount >= this.myCountToExecution;
        }

        public String toString() {
            return "current=" + this.myCurrentCount + " countToExecution=" + this.myCountToExecution;
        }
    }
}

