/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import org.jetbrains.jet.internal.com.intellij.openapi.util.Computable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.jet.internal.com.intellij.util.ThrowableRunnable;

public class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithClassLoader(ClassLoader classLoader, Runnable runnable) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithClassLoader(ClassLoader classLoader, Computable<T> computable) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = computable.compute();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> void runWithClassLoader(ClassLoader classLoader, ThrowableRunnable<E> runnable) throws E {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T runWithClassLoader(ClassLoader classLoader, ThrowableComputable<T, E> computable) throws E {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = computable.compute();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

