/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.KeyedExtensionCollector;
import org.jetbrains.jet.internal.com.intellij.util.ReflectionCache;
import org.jetbrains.jet.internal.gnu.trove.THashSet;

public class ClassExtension<T>
extends KeyedExtensionCollector<T, Class> {
    public ClassExtension(@NonNls String epName) {
        super(epName);
    }

    @Override
    protected String keyToString(Class key) {
        return key.getName();
    }

    @Override
    protected List<T> buildExtensions(String key, Class classKey) {
        THashSet<String> allSupers = new THashSet<String>();
        ClassExtension.collectSupers(classKey, allSupers);
        return this.buildExtensions(allSupers);
    }

    private static void collectSupers(Class classKey, Set<String> allSupers) {
        Class[] interfaces;
        allSupers.add(classKey.getName());
        for (Class anInterface : interfaces = ReflectionCache.getInterfaces(classKey)) {
            ClassExtension.collectSupers(anInterface, allSupers);
        }
        Class superClass = ReflectionCache.getSuperClass(classKey);
        if (superClass != null) {
            ClassExtension.collectSupers(superClass, allSupers);
        }
    }

    @Nullable
    public T forClass(Class t) {
        List ts = this.forKey(t);
        return ts.isEmpty() ? null : (T)ts.get(0);
    }
}

