/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.ui;

import javax.swing.JComponent;
import org.jetbrains.jet.internal.com.intellij.openapi.ui.Splitter;

public class PseudoSplitter
extends Splitter {
    private boolean myFirstIsFixed;
    private boolean mySecondIsFixed;
    private int myFirstFixedSize;
    private int mySecondFixedSize;

    public PseudoSplitter(boolean vertical) {
        super(vertical);
        this.myFirstIsFixed = false;
        this.mySecondIsFixed = false;
    }

    public PseudoSplitter(boolean vertical, float proportion) {
        super(vertical, proportion);
        this.myFirstIsFixed = true;
    }

    public PseudoSplitter(boolean vertical, float proportion, float minProp, float maxProp) {
        super(vertical, proportion, minProp, maxProp);
        this.myFirstIsFixed = true;
    }

    private int getSizeForComp(JComponent component) {
        return this.getOrientation() ? component.getHeight() : component.getWidth();
    }

    public void fixFirst(float proportion) {
        assert (this.getFirstComponent() != null);
        int comp = this.getSizeForComp(this);
        this.myFirstFixedSize = (int)((float)comp * proportion - (float)this.getDividerWidth());
        this.myFirstIsFixed = true;
        this.mySecondIsFixed = false;
    }

    public void fixFirst() {
        assert (this.getFirstComponent() != null);
        this.myFirstFixedSize = this.getSizeForComp(this.getFirstComponent());
        this.myFirstIsFixed = true;
        this.mySecondIsFixed = false;
    }

    public void fixSecond() {
        assert (this.getSecondComponent() != null);
        this.mySecondFixedSize = this.getSizeForComp(this.getSecondComponent());
        this.myFirstIsFixed = false;
        this.mySecondIsFixed = true;
    }

    public void freeAll() {
        this.myFirstIsFixed = false;
        this.mySecondIsFixed = false;
    }

    @Override
    public void doLayout() {
        int total = this.getSizeForComp(this);
        if (this.myFirstIsFixed) {
            this.myProportion = (float)this.myFirstFixedSize / (float)(total - this.getDividerWidth());
        } else if (this.mySecondIsFixed) {
            this.myProportion = ((float)total - (float)this.mySecondFixedSize) / (float)(total - this.getDividerWidth());
        }
        super.doLayout();
    }

    @Override
    public void setProportion(float proportion) {
        boolean firstIsFixed = this.myFirstIsFixed;
        boolean secondIsFixed = this.mySecondIsFixed;
        this.myFirstIsFixed = false;
        this.mySecondIsFixed = false;
        super.setProportion(proportion);
        int total = this.getSizeForComp(this);
        if (firstIsFixed) {
            this.myFirstFixedSize = (int)(this.myProportion * (float)(total - this.getDividerWidth()));
            this.myFirstIsFixed = true;
        } else if (secondIsFixed) {
            this.mySecondFixedSize = (int)((1.0f - this.myProportion) * (float)(total - this.getDividerWidth()));
            this.mySecondIsFixed = true;
        }
    }
}

