/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ModalityState;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DumbAware;
import org.jetbrains.jet.internal.com.intellij.openapi.project.PossiblyDumbAware;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.jet.internal.com.intellij.util.messages.Topic;

public abstract class DumbService {
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic<DumbModeListener>("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract boolean isDumb();

    public static boolean isDumb(Project project) {
        return DumbService.getInstance(project).isDumb();
    }

    public abstract void runWhenSmart(Runnable var1);

    public abstract void waitForSmartMode();

    public void smartInvokeLater(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.smartInvokeLater must not be null");
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbService.this.runWhenSmart(runnable);
            }
        });
    }

    public void smartInvokeLater(final @NotNull Runnable runnable, ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.smartInvokeLater must not be null");
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbService.this.runWhenSmart(runnable);
            }
        }, modalityState);
    }

    public static DumbService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.getInstance must not be null");
        }
        return INSTANCE_KEY.getValue(project);
    }

    public <T> List<T> filterByDumbAwareness(@Nullable Collection<T> collection) {
        if (this.isDumb()) {
            ArrayList<T> result = new ArrayList<T>(collection);
            Iterator<T> iterator = result.iterator();
            while (iterator.hasNext()) {
                if (DumbService.isDumbAware(iterator.next())) continue;
                iterator.remove();
            }
            return result;
        }
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public abstract JComponent wrapGently(@NotNull JComponent var1, @NotNull Disposable var2);

    public void makeDumbAware(final @NotNull JComponent component, @NotNull Disposable disposable) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.makeDumbAware must not be null");
        }
        if (disposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/project/DumbService.makeDumbAware must not be null");
        }
        component.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(disposable).subscribe(DUMB_MODE, new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                component.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                component.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(String var1);

    public abstract Project getProject();

    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    public static interface DumbModeListener {
        public void enteredDumbMode();

        public void exitDumbMode();
    }
}

