/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.extensions.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.AreaPicoContainer;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.DefaultPluginDescriptor;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionPointListener;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.LogProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.impl.AreaPicoContainerImpl;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentHashMap;
import org.jetbrains.jet.internal.com.intellij.util.containers.MultiMap;
import org.jetbrains.jet.internal.org.jdom.Attribute;
import org.jetbrains.jet.internal.org.jdom.Element;
import org.jetbrains.jet.internal.org.jdom.Namespace;
import org.jetbrains.jet.internal.org.jdom.output.Format;
import org.jetbrains.jet.internal.org.jdom.output.XMLOutputter;
import org.jetbrains.jet.internal.org.picocontainer.MutablePicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DefaultPicoContainer;

public class ExtensionsAreaImpl
implements ExtensionsArea {
    private final LogProvider myLogger;
    private static final Map<String, String> ourDefaultEPs = new HashMap<String, String>();
    private final AreaPicoContainerImpl myPicoContainer;
    private final Throwable myCreationTrace;
    private final Map<String, ExtensionPointImpl> myExtensionPoints;
    private final Map<String, Throwable> myEPTraces;
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners;
    private final List<Runnable> mySuspendedListenerActions;
    private boolean myAvailabilityNotificationsActive;
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;
    private final Map<Element, ExtensionComponentAdapter> myExtensionElement2extension;
    private final Map<String, DefaultPicoContainer> myPluginName2picoContainer;

    public ExtensionsAreaImpl(String areaClass, AreaInstance areaInstance, PicoContainer parentPicoContainer, @NotNull LogProvider logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.<init> must not be null");
        }
        this.myExtensionPoints = new ConcurrentHashMap<String, ExtensionPointImpl>();
        this.myEPTraces = new HashMap<String, Throwable>();
        this.myAvailabilityListeners = new MultiMap();
        this.mySuspendedListenerActions = new ArrayList<Runnable>();
        this.myAvailabilityNotificationsActive = true;
        this.myExtensionElement2extension = new HashMap<Element, ExtensionComponentAdapter>();
        this.myPluginName2picoContainer = new HashMap<String, DefaultPicoContainer>();
        this.myCreationTrace = null;
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new AreaPicoContainerImpl(parentPicoContainer, areaInstance);
        this.myLogger = logger;
        this.initialize();
    }

    public ExtensionsAreaImpl(MutablePicoContainer picoContainer, LogProvider logger) {
        this(null, null, picoContainer, logger);
    }

    public final void notifyAreaReplaced() {
        for (ExtensionPointImpl point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
        }
    }

    @Override
    public AreaPicoContainer getPicoContainer() {
        return this.myPicoContainer;
    }

    MutablePicoContainer getMutablePicoContainer() {
        return this.myPicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    @Override
    public void registerExtensionPoint(String pluginName, Element extensionPointElement) {
        this.registerExtensionPoint(new DefaultPluginDescriptor(PluginId.getId(pluginName)), extensionPointElement);
    }

    @Override
    public void registerExtensionPoint(PluginDescriptor pluginDescriptor, Element extensionPointElement) {
        ExtensionPoint.Kind kind;
        String className;
        assert (pluginDescriptor.getPluginId() != null);
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        String epName = extensionPointElement.getAttributeValue("qualifiedName");
        if (epName == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + pluginId + "' plugin");
            }
            epName = pluginId + '.' + name;
        }
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (interfaceClassName != null) {
            className = interfaceClassName;
            kind = ExtensionPoint.Kind.INTERFACE;
        } else {
            className = beanClassName;
            kind = ExtensionPoint.Kind.BEAN_CLASS;
        }
        this.registerExtensionPoint(epName, className, pluginDescriptor, kind);
    }

    @Override
    public void registerExtension(String pluginName, Element extensionElement) {
        this.registerExtension(new DefaultPluginDescriptor(PluginId.getId(pluginName)), extensionElement);
    }

    @Override
    public void registerExtension(PluginDescriptor pluginDescriptor, Element extensionElement) {
        ExtensionComponentAdapter adapter;
        PluginId pluginId = pluginDescriptor.getPluginId();
        String epName = ExtensionsAreaImpl.extractEPName(extensionElement);
        PicoContainer container = this.getPluginContainer(pluginId.getIdString());
        ExtensionPoint extensionPoint = this.getExtensionPoint(epName);
        if (extensionPoint.getKind() == ExtensionPoint.Kind.INTERFACE) {
            String implClass = extensionElement.getAttributeValue("implementation");
            if (implClass == null) {
                throw new RuntimeException("'implementation' attribute not specified for '" + epName + "' extension in '" + pluginId.getIdString() + "' plugin");
            }
            adapter = new ExtensionComponentAdapter(implClass, extensionElement, container, pluginDescriptor, ExtensionsAreaImpl.shouldDeserializeInstance(extensionElement));
        } else {
            adapter = new ExtensionComponentAdapter(extensionPoint.getClassName(), extensionElement, container, pluginDescriptor, true);
        }
        this.myExtensionElement2extension.put(extensionElement, adapter);
        this.internalGetPluginContainer().registerComponent(adapter);
        ((ExtensionPointImpl)this.getExtensionPoint(epName)).registerExtensionAdapter(adapter);
    }

    private static boolean shouldDeserializeInstance(Element extensionElement) {
        if (!extensionElement.getContent().isEmpty()) {
            return true;
        }
        for (Attribute attribute : extensionElement.getAttributes()) {
            String name = attribute.getName();
            if ("implementation".equals(name) || "id".equals(name) || "order".equals(name)) continue;
            return true;
        }
        return false;
    }

    private static String extractEPName(Element extensionElement) {
        String epName = extensionElement.getAttributeValue("point");
        if (epName == null) {
            String ns;
            Element parentElement = extensionElement.getParentElement();
            String string = ns = parentElement != null ? parentElement.getAttributeValue("defaultExtensionNs") : null;
            if (ns != null) {
                epName = ns + '.' + extensionElement.getName();
            } else {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            }
        }
        return epName;
    }

    @Override
    public PicoContainer getPluginContainer(String pluginName) {
        return this.internalGetPluginContainer();
    }

    private MutablePicoContainer internalGetPluginContainer() {
        return this.myPicoContainer;
    }

    private void disposePluginContainer(String pluginName) {
        DefaultPicoContainer pluginContainer = this.myPluginName2picoContainer.remove(pluginName);
        if (pluginContainer != null) {
            this.myPicoContainer.removeChildContainer(pluginContainer);
        }
    }

    @Override
    public void unregisterExtensionPoint(String pluginName, Element extensionPointElement) {
        assert (pluginName != null);
        String epName = pluginName + '.' + extensionPointElement.getAttributeValue("name");
        this.unregisterExtensionPoint(epName);
    }

    @Override
    public void unregisterExtension(String pluginName, Element extensionElement) {
        String epName = ExtensionsAreaImpl.extractEPName(extensionElement);
        if (!this.myExtensionElement2extension.containsKey(extensionElement)) {
            XMLOutputter xmlOutputter = new XMLOutputter();
            Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.NORMALIZE);
            xmlOutputter.setFormat(format);
            StringWriter stringWriter = new StringWriter();
            try {
                xmlOutputter.output(extensionElement, (Writer)stringWriter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.myLogger.warn(stringWriter.toString());
            throw new IllegalArgumentException("Trying to unregister extension element that was never registered");
        }
        ExtensionComponentAdapter adapter = this.myExtensionElement2extension.remove(extensionElement);
        if (adapter == null) {
            return;
        }
        if (((ExtensionPointImpl)this.getExtensionPoint(epName)).unregisterComponentAdapter(adapter)) {
            MutablePicoContainer pluginContainer = this.internalGetPluginContainer();
            pluginContainer.unregisterComponent(adapter.getComponentKey());
            if (pluginContainer.getComponentAdapters().isEmpty()) {
                this.disposePluginContainer(pluginName);
            }
        }
    }

    private void initialize() {
        for (Map.Entry<String, String> entry : ourDefaultEPs.entrySet()) {
            String epName = entry.getKey();
            this.registerExtensionPoint(epName, entry.getValue());
        }
        ((ExtensionPointImpl)this.getExtensionPoint("org.jetbrains.jet.internal.com.intellij.openapi.extensions.epAvailabilityListener")).addExtensionPointListener(new ExtensionPointListener(){

            public void extensionRemoved(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1.extensionRemoved must not be null");
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get(epListenerExtension.getExtensionPointName());
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator.next();
                    if (!listener.getClass().getName().equals(epListenerExtension.getListenerClass())) continue;
                    iterator.remove();
                    return;
                }
                ExtensionsAreaImpl.this.myLogger.warn("Failed to find EP availability listener: " + epListenerExtension.getListenerClass());
            }

            public void extensionAdded(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1.extensionAdded must not be null");
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                try {
                    String epName = epListenerExtension.getExtensionPointName();
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(epListenerExtension.loadListenerClass());
                    ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Object instantiate(Class clazz) {
        ConstructorInjectionComponentAdapter adapter = new ConstructorInjectionComponentAdapter(Integer.toString(System.identityHashCode(new Object())), clazz);
        return adapter.getComponentInstance(this.getPicoContainer());
    }

    public Throwable getCreationTrace() {
        return this.myCreationTrace;
    }

    @Override
    public void addAvailabilityListener(String epName, ExtensionPointAvailabilityListener listener) {
        this.myAvailabilityListeners.putValue(epName, listener);
        if (this.hasExtensionPoint(epName)) {
            this.notifyAvailableListener(listener, this.myExtensionPoints.get(epName));
        }
    }

    @Override
    public void registerExtensionPoint(String extensionPointName, String extensionPointBeanClass) {
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, ExtensionPoint.Kind.INTERFACE);
    }

    @Override
    public void registerExtensionPoint(@NonNls String extensionPointName, String extensionPointBeanClass, ExtensionPoint.Kind kind) {
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, new UndefinedPluginDescriptor(), kind);
    }

    @Override
    public void registerExtensionPoint(String extensionPointName, String extensionPointBeanClass, PluginDescriptor descriptor) {
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, descriptor, ExtensionPoint.Kind.INTERFACE);
    }

    private void registerExtensionPoint(String extensionPointName, String extensionPointBeanClass, PluginDescriptor descriptor, ExtensionPoint.Kind kind) {
        if (this.hasExtensionPoint(extensionPointName)) {
            throw new RuntimeException("Duplicate registration for EP: " + extensionPointName);
        }
        this.registerExtensionPoint(new ExtensionPointImpl(extensionPointName, extensionPointBeanClass, kind, this, this.myAreaInstance, this.myLogger, descriptor));
    }

    public void registerExtensionPoint(ExtensionPointImpl extensionPoint) {
        String name = extensionPoint.getName();
        this.myExtensionPoints.put(name, extensionPoint);
        this.notifyEPRegistered(extensionPoint);
    }

    @Override
    public void registerAreaExtensionsAndPoints(PluginDescriptor pluginDescriptor, List<Element> extensionsPoints, List<Element> extensions) {
        Element element;
        int i;
        int size;
        String areaClass = this.getAreaClass();
        if (extensionsPoints != null) {
            size = extensionsPoints.size();
            for (i = 0; i < size; ++i) {
                element = extensionsPoints.get(i);
                if (!ExtensionsAreaImpl.equal(areaClass, element.getAttributeValue("area"))) continue;
                this.registerExtensionPoint(pluginDescriptor, element);
            }
        }
        if (extensions != null) {
            size = extensions.size();
            for (i = 0; i < size; ++i) {
                element = extensions.get(i);
                if (!this.hasExtensionPoint(ExtensionsAreaImpl.extractEPName(element))) continue;
                this.registerExtension(pluginDescriptor, element);
            }
        }
    }

    private static boolean equal(String areaClass, String anotherAreaClass) {
        return areaClass == null ? anotherAreaClass == null : areaClass.equals(anotherAreaClass);
    }

    private void notifyEPRegistered(ExtensionPoint extensionPoint) {
        Collection<ExtensionPointAvailabilityListener> listeners = this.myAvailabilityListeners.get(extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyAvailableListener(listener, extensionPoint);
        }
    }

    private void notifyAvailableListener(final ExtensionPointAvailabilityListener listener, final ExtensionPoint extensionPoint) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRegistered(extensionPoint);
            }
        });
    }

    private void queueNotificationAction(Runnable action) {
        if (this.myAvailabilityNotificationsActive) {
            action.run();
        } else {
            this.mySuspendedListenerActions.add(action);
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(String extensionPointName) {
        ExtensionPointImpl extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        ExtensionPointImpl extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.getExtensionPoint must not return null");
        }
        return extensionPointImpl;
    }

    @Override
    public <T> ExtensionPoint<T> getExtensionPoint(ExtensionPointName<T> extensionPointName) {
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.myExtensionPoints.values().toArray(new ExtensionPoint[this.myExtensionPoints.size()]);
    }

    @Override
    public void unregisterExtensionPoint(String extensionPointName) {
        ExtensionPoint extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint != null) {
            extensionPoint.reset();
            this.myExtensionPoints.remove(extensionPointName);
            this.notifyEPRemoved(extensionPoint);
        }
    }

    private void notifyEPRemoved(ExtensionPoint extensionPoint) {
        Collection<ExtensionPointAvailabilityListener> listeners = this.myAvailabilityListeners.get(extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyUnavailableListener(extensionPoint, listener);
        }
    }

    private void notifyUnavailableListener(final ExtensionPoint extensionPoint, final ExtensionPointAvailabilityListener listener) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRemoved(extensionPoint);
            }
        });
    }

    @Override
    public boolean hasExtensionPoint(String extensionPointName) {
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public void suspendInteractions() {
        this.myAvailabilityNotificationsActive = false;
    }

    @Override
    public void resumeInteractions() {
        ExtensionPoint[] extensionPoints;
        this.myAvailabilityNotificationsActive = true;
        for (ExtensionPoint extensionPoint : extensionPoints = this.getExtensionPoints()) {
            extensionPoint.getExtensions();
        }
        for (Runnable action : this.mySuspendedListenerActions) {
            try {
                action.run();
            }
            catch (Exception e) {
                this.myLogger.error(e);
            }
        }
        this.mySuspendedListenerActions.clear();
    }

    @Override
    public void killPendingInteractions() {
        this.mySuspendedListenerActions.clear();
    }

    public MutablePicoContainer[] getPluginContainers() {
        return this.myPluginName2picoContainer.values().toArray(new MutablePicoContainer[this.myPluginName2picoContainer.values().size()]);
    }

    public void removeAllComponents(Set<ExtensionComponentAdapter> extensionAdapters) {
        Iterator<ExtensionComponentAdapter> i$ = extensionAdapters.iterator();
        while (i$.hasNext()) {
            ExtensionComponentAdapter extensionAdapter;
            ExtensionComponentAdapter componentAdapter = extensionAdapter = i$.next();
            this.internalGetPluginContainer().unregisterComponent(componentAdapter.getComponentKey());
        }
    }

    static {
        ourDefaultEPs.put("org.jetbrains.jet.internal.com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class.getName());
    }
}

