/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.jet.internal.com.intellij.util.NullableFunction;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public abstract class SmartExtensionPoint<Extension, V>
implements ExtensionPointAndAreaListener<Extension> {
    private final Collection<V> myExplicitExtensions;
    private ExtensionPoint<Extension> myExtensionPoint;
    private List<V> myCache;

    protected SmartExtensionPoint(@NotNull Collection<V> explicitExtensions) {
        if (explicitExtensions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/SmartExtensionPoint.<init> must not be null");
        }
        this.myExplicitExtensions = explicitExtensions;
    }

    @NotNull
    protected abstract ExtensionPoint<Extension> getExtensionPoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/SmartExtensionPoint.addExplicitExtension must not be null");
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.add(extension);
            this.myCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/SmartExtensionPoint.removeExplicitExtension must not be null");
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.remove(extension);
            this.myCache = null;
        }
    }

    @Nullable
    protected abstract V getExtension(@NotNull Extension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<V> getExtensions() {
        Collection<V> collection = this.myExplicitExtensions;
        // MONITORENTER : collection
        if (this.myCache == null) {
            this.myExtensionPoint = this.getExtensionPoint();
            this.myExtensionPoint.addExtensionPointListener(this);
            this.myCache = new ArrayList<V>(this.myExplicitExtensions);
            this.myCache.addAll(ContainerUtil.mapNotNull(this.myExtensionPoint.getExtensions(), new NullableFunction<Extension, V>(){

                @Override
                @Nullable
                public V fun(Extension extension) {
                    return SmartExtensionPoint.this.getExtension(extension);
                }
            }));
        }
        List<V> list = this.myCache;
        // MONITOREXIT : collection
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/SmartExtensionPoint.getExtensions must not return null");
    }

    @Override
    public final void extensionAdded(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/SmartExtensionPoint.extensionAdded must not be null");
        }
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCache() {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            if (this.myCache != null) {
                this.myCache = null;
                this.myExtensionPoint.removeExtensionPointListener(this);
                this.myExtensionPoint = null;
            }
        }
    }

    @Override
    public final void extensionRemoved(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/SmartExtensionPoint.extensionRemoved must not be null");
        }
        this.dropCache();
    }

    @Override
    public void areaReplaced(ExtensionsArea area) {
        this.dropCache();
    }
}

