/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.SortingException;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.util.graph.CachingSemiGraph;
import org.jetbrains.jet.internal.com.intellij.util.graph.DFSTBuilder;
import org.jetbrains.jet.internal.com.intellij.util.graph.GraphGenerator;
import org.jetbrains.jet.internal.org.jdom.Element;

public class LoadingOrder {
    public static final LoadingOrder ANY = new LoadingOrder();
    public static final LoadingOrder FIRST = new LoadingOrder("FIRST");
    public static final LoadingOrder LAST = new LoadingOrder("LAST");
    @NonNls
    private final String myName;
    private final boolean myFirst;
    private final boolean myLast;
    private final Set<String> myBefore;
    private final Set<String> myAfter;

    private LoadingOrder() {
        this.myBefore = new HashSet<String>(2);
        this.myAfter = new HashSet<String>(2);
        this.myName = "ANY";
        this.myFirst = false;
        this.myLast = false;
    }

    private LoadingOrder(@NonNls @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/LoadingOrder.<init> must not be null");
        }
        this.myBefore = new HashSet<String>(2);
        this.myAfter = new HashSet<String>(2);
        this.myName = text;
        boolean last = false;
        boolean first = false;
        for (String string : StringUtil.split(text, ",")) {
            String trimmed = string.trim();
            if (trimmed.equalsIgnoreCase("FIRST")) {
                first = true;
                continue;
            }
            if (trimmed.equalsIgnoreCase("LAST")) {
                last = true;
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "BEFORE ")) {
                this.myBefore.add(trimmed.substring("BEFORE ".length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "BEFORE:")) {
                this.myBefore.add(trimmed.substring("BEFORE:".length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "AFTER ")) {
                this.myAfter.add(trimmed.substring("AFTER ".length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "AFTER:")) {
                this.myAfter.add(trimmed.substring("AFTER:".length()).trim());
                continue;
            }
            throw new AssertionError((Object)("Invalid specification: " + trimmed + "; should be one of FIRST, LAST, BEFORE <id> or AFTER <id>"));
        }
        this.myFirst = first;
        this.myLast = last;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadingOrder)) {
            return false;
        }
        LoadingOrder that = (LoadingOrder)o;
        if (this.myFirst != that.myFirst) {
            return false;
        }
        if (this.myLast != that.myLast) {
            return false;
        }
        if (!((Object)this.myAfter).equals(that.myAfter)) {
            return false;
        }
        return ((Object)this.myBefore).equals(that.myBefore);
    }

    public int hashCode() {
        int result = this.myFirst ? 1 : 0;
        result = 31 * result + (this.myLast ? 1 : 0);
        result = 31 * result + ((Object)this.myBefore).hashCode();
        result = 31 * result + ((Object)this.myAfter).hashCode();
        return result;
    }

    public static LoadingOrder before(@NonNls String id) {
        return new LoadingOrder("BEFORE " + id);
    }

    public static LoadingOrder after(@NonNls String id) {
        return new LoadingOrder("AFTER " + id);
    }

    public static void sort(final Orderable[] orderables) {
        final HashMap<String, Orderable> map = new HashMap<String, Orderable>();
        final HashMap<Orderable, LoadingOrder> cachedMap = new HashMap<Orderable, LoadingOrder>(orderables.length);
        final HashSet<Orderable> first = new HashSet<Orderable>(1);
        final HashSet<Orderable> hasBefore = new HashSet<Orderable>(orderables.length);
        for (Orderable o : orderables) {
            String id = o.getOrderId();
            if (StringUtil.isNotEmpty(id)) {
                map.put(id, o);
            }
            LoadingOrder order = o.getOrder();
            cachedMap.put(o, order);
            if (order.myFirst) {
                first.add(o);
            }
            if (order.myBefore.size() == 0) continue;
            hasBefore.add(o);
        }
        DFSTBuilder<Orderable> builder = new DFSTBuilder<Orderable>(new GraphGenerator<Orderable>(new CachingSemiGraph<Orderable>(new GraphGenerator.SemiGraph<Orderable>(){

            @Override
            public Collection<Orderable> getNodes() {
                ArrayList<Orderable> list = new ArrayList<Orderable>(Arrays.asList(orderables));
                Collections.reverse(list);
                return list;
            }

            @Override
            public Iterator<Orderable> getIn(Orderable n) {
                LoadingOrder order = (LoadingOrder)cachedMap.get(n);
                LinkedHashSet<Orderable> predecessors = new LinkedHashSet<Orderable>();
                for (String id : order.myAfter) {
                    Orderable orderable = (Orderable)map.get(id);
                    if (orderable == null) continue;
                    predecessors.add(orderable);
                }
                String id = n.getOrderId();
                if (StringUtil.isNotEmpty(id)) {
                    for (Orderable orderable : hasBefore) {
                        LoadingOrder hisOrder = (LoadingOrder)cachedMap.get(orderable);
                        if (!hisOrder.myBefore.contains(id)) continue;
                        predecessors.add(orderable);
                    }
                }
                if (order.myLast) {
                    for (Orderable orderable : orderables) {
                        LoadingOrder hisOrder = (LoadingOrder)cachedMap.get(orderable);
                        if (hisOrder.myLast) continue;
                        predecessors.add(orderable);
                    }
                }
                if (!order.myFirst) {
                    for (Orderable orderable : first) {
                        predecessors.add(orderable);
                    }
                }
                return predecessors.iterator();
            }
        })));
        if (!builder.isAcyclic()) {
            Pair<Orderable, Orderable> dependency = builder.getCircularDependency();
            throw new SortingException("Could not satisfy sorting requirements", new Element[]{((Orderable)dependency.first).getDescribingElement(), ((Orderable)dependency.second).getDescribingElement()});
        }
        Arrays.sort(orderables, builder.comparator());
    }

    public static LoadingOrder readOrder(@NonNls String orderAttr) {
        return orderAttr != null ? new LoadingOrder(orderAttr) : ANY;
    }

    public static interface Orderable {
        @Nullable
        public String getOrderId();

        public LoadingOrder getOrder();

        public Element getDescribingElement();
    }
}

