/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.extensions;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public class ExtensionPointName<T> {
    private final String myName;

    public ExtensionPointName(@NonNls String name) {
        this.myName = name;
    }

    public static <T> ExtensionPointName<T> create(@NonNls String name) {
        return new ExtensionPointName<T>(name);
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public T[] getExtensions() {
        T[] TArray = Extensions.getExtensions(this);
        if (TArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/ExtensionPointName.getExtensions must not return null");
        }
        return TArray;
    }

    public <V extends T> V findExtension(Class<V> instanceOf) {
        return ContainerUtil.findInstance(this.getExtensions(), instanceOf);
    }
}

