/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.extensions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.PluginAware;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public abstract class AbstractExtensionPointBean
implements PluginAware {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.AbstractExtensionPointBean");
    protected PluginDescriptor myPluginDescriptor;

    @Override
    public final void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.myPluginDescriptor = pluginDescriptor;
    }

    @NotNull
    public final <T> Class<T> findClass(String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className, true, this.getLoaderForClass());
        if (clazz == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/AbstractExtensionPointBean.findClass must not return null");
        }
        return clazz;
    }

    @Nullable
    public final <T> Class<T> findClassNoExceptions(String className) {
        try {
            return this.findClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Problem loading class " + className + " from plugin " + this.myPluginDescriptor.getPluginId().getIdString(), e);
            return null;
        }
    }

    public ClassLoader getLoaderForClass() {
        return this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
    }

    @NotNull
    public final <T> T instantiate(String className, @NotNull PicoContainer container) throws ClassNotFoundException {
        if (container == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/AbstractExtensionPointBean.instantiate must not be null");
        }
        T t = AbstractExtensionPointBean.instantiate(this.findClass(className), container);
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/AbstractExtensionPointBean.instantiate must not return null");
        }
        return t;
    }

    @NotNull
    public static <T> T instantiate(@NotNull Class<T> aClass, @NotNull PicoContainer container) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/AbstractExtensionPointBean.instantiate must not be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/AbstractExtensionPointBean.instantiate must not be null");
        }
        T t = AbstractExtensionPointBean.instantiate(aClass, container, false);
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/AbstractExtensionPointBean.instantiate must not return null");
        }
        return t;
    }

    @NotNull
    public static <T> T instantiate(@NotNull Class<T> aClass, @NotNull PicoContainer container, boolean allowNonPublicClasses) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/AbstractExtensionPointBean.instantiate must not be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/AbstractExtensionPointBean.instantiate must not be null");
        }
        Object object = new ConstructorInjectionComponentAdapter(aClass.getName(), aClass, null, allowNonPublicClasses).getComponentInstance(container);
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/AbstractExtensionPointBean.instantiate must not return null");
        }
        return (T)object;
    }
}

