/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.TextChange;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.impl.TextChangeImpl;
import org.jetbrains.jet.internal.com.intellij.util.text.CharArrayUtil;

public class TextChangesStorage {
    private final List<ChangeEntry> myChanges = new ArrayList<ChangeEntry>();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<TextChangeImpl> getChanges() {
        List<TextChangeImpl> list;
        if (this.myChanges.isEmpty()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/TextChangesStorage.getChanges must not return null");
            return list;
        }
        ArrayList<TextChangeImpl> result = new ArrayList<TextChangeImpl>(this.myChanges.size());
        for (ChangeEntry changeEntry : this.myChanges) {
            result.add(changeEntry.change);
        }
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/TextChangesStorage.getChanges must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<? extends TextChange> getChanges(int start, int end) {
        List<Object> list;
        assert (start <= end);
        int changeStartIndex = this.getChangeIndex(start);
        if (changeStartIndex < 0) {
            changeStartIndex = -changeStartIndex - 1;
        }
        if (changeStartIndex >= this.myChanges.size()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/TextChangesStorage.getChanges must not return null");
            return list;
        }
        int changeEndIndex = this.getChangeIndex(end);
        boolean endInclusive = true;
        if (changeEndIndex < 0) {
            changeEndIndex = -changeEndIndex - 1;
            endInclusive = false;
        }
        ArrayList<TextChangeImpl> result = null;
        for (int i = changeStartIndex; i <= changeEndIndex && (endInclusive || i != changeEndIndex); ++i) {
            if (result == null) {
                result = new ArrayList<TextChangeImpl>();
            }
            result.add(this.myChanges.get((int)i).change);
        }
        list = result == null ? Collections.emptyList() : result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/TextChangesStorage.getChanges must not return null");
    }

    public boolean isEmpty() {
        return this.myChanges.isEmpty();
    }

    public void clear() {
        this.myChanges.clear();
    }

    public int size() {
        return this.myChanges.size();
    }

    public void store(@NotNull TextChange change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/TextChangesStorage.store must not be null");
        }
        if (this.myChanges.isEmpty()) {
            this.myChanges.add(new ChangeEntry(new TextChangeImpl(change.getText(), change.getStart(), change.getEnd()), change.getStart()));
            return;
        }
        ChangeEntry last = this.myChanges.get(this.myChanges.size() - 1);
        if (last.clientStartOffset + last.change.getText().length() < change.getStart()) {
            int clientShift = last.clientStartOffset - last.change.getStart() + last.change.getDiff();
            this.myChanges.add(new ChangeEntry(new TextChangeImpl(change.getText(), change.getStart() - clientShift, change.getEnd() - clientShift), change.getStart()));
            return;
        }
        int insertionIndex = this.doStore(change);
        if (insertionIndex < 0) {
            return;
        }
        this.mergeIfNecessary(insertionIndex);
    }

    private int doStore(@NotNull TextChange change) {
        ChangeEntry changeEntry;
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/TextChangesStorage.doStore must not be null");
        }
        int newChangeStart = change.getStart();
        int newChangeEnd = change.getEnd();
        int insertionIndex = this.getChangeIndex(change.getStart());
        int clientShift = 0;
        int changeDiff = change.getText().length() - (change.getEnd() - change.getStart());
        if (insertionIndex < 0) {
            if ((insertionIndex = -insertionIndex - 1) >= this.myChanges.size()) {
                if (!this.myChanges.isEmpty()) {
                    ChangeEntry changeEntry2 = this.myChanges.get(this.myChanges.size() - 1);
                    clientShift = changeEntry2.clientStartOffset - changeEntry2.change.getStart() + changeEntry2.change.getDiff();
                }
                this.myChanges.add(new ChangeEntry(new TextChangeImpl(change.getText(), change.getStart() - clientShift, change.getEnd() - clientShift), change.getStart()));
                return insertionIndex;
            }
            if (insertionIndex > 0 && !this.myChanges.isEmpty()) {
                changeEntry = this.myChanges.get(insertionIndex - 1);
                clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart() + changeEntry.change.getDiff();
            }
        } else {
            changeEntry = this.myChanges.get(insertionIndex);
            clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart();
        }
        boolean updateClientOffsetOnly = false;
        for (int i = insertionIndex; i < this.myChanges.size(); ++i) {
            CharSequence adjustedText;
            ChangeEntry changeEntry3 = this.myChanges.get(i);
            int storedClientStart = changeEntry3.change.getStart() + clientShift;
            CharSequence storedText = changeEntry3.change.getText();
            int storedClientEnd = storedClientStart + storedText.length();
            if (!updateClientOffsetOnly && storedClientStart > newChangeEnd) {
                if (changeDiff == 0) break;
                updateClientOffsetOnly = true;
            }
            if (updateClientOffsetOnly) {
                changeEntry3.clientStartOffset += changeDiff;
                continue;
            }
            if (storedClientEnd <= newChangeStart) {
                clientShift += changeEntry3.change.getDiff();
                insertionIndex = i + 1;
                continue;
            }
            if (storedClientStart <= newChangeStart && storedClientEnd >= newChangeEnd) {
                adjustedText = new StringBuilder();
                if (storedClientStart < newChangeStart) {
                    adjustedText.append(storedText.subSequence(0, newChangeStart - storedClientStart));
                }
                adjustedText.append(change.getText());
                if (storedClientEnd > newChangeEnd) {
                    adjustedText.append(storedText.subSequence(newChangeEnd - storedClientStart, storedText.length()));
                }
                if (adjustedText.length() == 0 && changeEntry3.change.getStart() == changeEntry3.change.getEnd()) {
                    this.myChanges.remove(i);
                    insertionIndex = -1;
                    updateClientOffsetOnly = true;
                    --i;
                    continue;
                }
                changeEntry3.change = new TextChangeImpl(adjustedText, changeEntry3.change.getStart(), changeEntry3.change.getEnd());
                insertionIndex = -1;
                updateClientOffsetOnly = true;
                continue;
            }
            if (newChangeStart <= storedClientStart && newChangeEnd >= storedClientEnd) {
                this.myChanges.remove(i);
                insertionIndex = i--;
                newChangeEnd -= changeEntry3.change.getDiff();
                continue;
            }
            if (newChangeStart <= storedClientStart && newChangeEnd > storedClientStart) {
                int numberOfStoredChangeSymbolsToRemove = newChangeEnd - storedClientStart;
                CharSequence adjustedText2 = storedText.subSequence(numberOfStoredChangeSymbolsToRemove, storedText.length());
                changeEntry3.change = new TextChangeImpl(adjustedText2, changeEntry3.change.getStart(), changeEntry3.change.getEnd());
                changeEntry3.clientStartOffset += changeDiff + numberOfStoredChangeSymbolsToRemove;
                newChangeEnd -= numberOfStoredChangeSymbolsToRemove;
                insertionIndex = i;
                continue;
            }
            if (newChangeStart < storedClientEnd && newChangeEnd >= storedClientEnd) {
                TextChangeImpl adjusted;
                adjustedText = storedText.subSequence(0, newChangeStart - storedClientStart);
                changeEntry3.change = adjusted = new TextChangeImpl(adjustedText, changeEntry3.change.getStart(), changeEntry3.change.getEnd());
                clientShift += adjusted.getDiff();
                newChangeEnd -= storedClientEnd - newChangeStart;
                insertionIndex = i + 1;
                continue;
            }
            if (newChangeEnd != storedClientStart) continue;
            changeEntry3.clientStartOffset += changeDiff;
        }
        if (insertionIndex >= 0) {
            this.myChanges.add(insertionIndex, new ChangeEntry(new TextChangeImpl(change.getText(), newChangeStart - clientShift, newChangeEnd - clientShift), change.getStart()));
        }
        return insertionIndex;
    }

    private void mergeIfNecessary(int insertionIndex) {
        String text;
        ChangeEntry left;
        ChangeEntry toMerge = this.myChanges.get(insertionIndex);
        if (insertionIndex > 0 && (left = this.myChanges.get(insertionIndex - 1)).getClientEndOffset() == toMerge.clientStartOffset && left.change.getEnd() == toMerge.change.getStart()) {
            text = ((Object)left.change.getText()).toString() + toMerge.change.getText();
            left.change = new TextChangeImpl(text, left.change.getStart(), toMerge.change.getEnd());
            this.myChanges.remove(insertionIndex);
            --insertionIndex;
        }
        toMerge = this.myChanges.get(insertionIndex);
        if (insertionIndex < this.myChanges.size() - 1) {
            ChangeEntry right = this.myChanges.get(insertionIndex + 1);
            if (toMerge.getClientEndOffset() == right.clientStartOffset && toMerge.change.getEnd() == right.change.getStart()) {
                text = ((Object)toMerge.change.getText()).toString() + right.change.getText();
                toMerge.change = new TextChangeImpl(text, toMerge.change.getStart(), right.change.getEnd());
                this.myChanges.remove(insertionIndex + 1);
            }
        }
    }

    public char charAt(@NotNull char[] originalData, int index) {
        if (originalData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/TextChangesStorage.charAt must not be null");
        }
        int changeIndex = this.getChangeIndex(index);
        if (changeIndex >= 0) {
            ChangeEntry changeEntry = this.myChanges.get(changeIndex);
            if (changeEntry.change.getText().length() > index - changeEntry.clientStartOffset) {
                return changeEntry.change.getText().charAt(index - changeEntry.clientStartOffset);
            }
            int originalArrayIndex = index - (changeEntry.clientStartOffset - changeEntry.change.getStart() + changeEntry.change.getDiff());
            return originalData[originalArrayIndex];
        }
        changeIndex = -changeIndex - 1;
        int clientShift = 0;
        if (changeIndex > 0 && changeIndex <= this.myChanges.size()) {
            ChangeEntry changeEntry = this.myChanges.get(changeIndex - 1);
            clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart() + changeEntry.change.getDiff();
        }
        return originalData[index - clientShift];
    }

    public CharSequence substring(@NotNull char[] originalData, int start, int end) {
        ChangeEntry changeEntry;
        if (originalData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/TextChangesStorage.substring must not be null");
        }
        if (this.myChanges.isEmpty()) {
            return new String(originalData, start, end - start);
        }
        if (end == start) {
            return "";
        }
        int startChangeIndex = this.getChangeIndex(start);
        int endChangeIndex = this.getChangeIndex(end);
        boolean substringAffectedByChanges = startChangeIndex >= 0 || endChangeIndex >= 0 || startChangeIndex != endChangeIndex;
        int clientShift = 0;
        int originalStart = 0;
        if (startChangeIndex < 0) {
            if ((startChangeIndex = -startChangeIndex - 1) > 0 && startChangeIndex <= this.myChanges.size()) {
                changeEntry = this.myChanges.get(startChangeIndex - 1);
                clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart() + changeEntry.change.getDiff();
                originalStart = changeEntry.change.getEnd();
            }
        } else {
            changeEntry = this.myChanges.get(startChangeIndex);
            clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart();
        }
        if (!substringAffectedByChanges) {
            return new String(originalData, start - clientShift, end - start);
        }
        char[] data = new char[end - start];
        int outputOffset = 0;
        for (int i = startChangeIndex; i < this.myChanges.size() && outputOffset < data.length; ++i) {
            ChangeEntry changeEntry2 = this.myChanges.get(i);
            int clientStart = changeEntry2.clientStartOffset;
            if (clientStart >= end) {
                if (i == startChangeIndex) {
                    return new String(originalData, start - clientShift, end - start);
                }
                System.arraycopy(originalData, originalStart, data, outputOffset, data.length - outputOffset);
                break;
            }
            int clientEnd = clientStart + changeEntry2.change.getText().length();
            if (clientEnd > start) {
                if (clientStart > start) {
                    int length = Math.min(clientStart - start, changeEntry2.change.getStart() - originalStart);
                    length = Math.min(length, data.length - outputOffset);
                    System.arraycopy(originalData, changeEntry2.change.getStart() - length, data, outputOffset, length);
                    if ((outputOffset += length) >= data.length) break;
                }
                if (end >= clientStart && clientStart < clientEnd) {
                    int changeTextStartOffset = start <= clientStart ? 0 : start - clientStart;
                    int length = Math.min(clientEnd, end) - Math.max(clientStart, start);
                    CharArrayUtil.getChars(changeEntry2.change.getText(), data, changeTextStartOffset, outputOffset, length);
                    outputOffset += length;
                }
            }
            originalStart = changeEntry2.change.getEnd();
        }
        if (outputOffset < data.length) {
            System.arraycopy(originalData, originalStart, data, outputOffset, data.length - outputOffset);
        }
        return new String(data);
    }

    private int getChangeIndex(int clientOffset) {
        if (this.myChanges.isEmpty()) {
            return -1;
        }
        int start = 0;
        int end = this.myChanges.size() - 1;
        while (start <= end) {
            int i = end + start >>> 1;
            ChangeEntry changeEntry = this.myChanges.get(i);
            if (changeEntry.clientStartOffset > clientOffset) {
                end = i - 1;
                continue;
            }
            if (changeEntry.clientStartOffset + changeEntry.change.getText().length() < clientOffset) {
                start = i + 1;
                continue;
            }
            return i;
        }
        return -(start + 1);
    }

    public String toString() {
        return this.myChanges.toString();
    }

    private static class ChangeEntry {
        public TextChangeImpl change;
        public int clientStartOffset;

        ChangeEntry(TextChangeImpl change, int clientStartOffset) {
            this.change = change;
            this.clientStartOffset = clientStartOffset;
        }

        public int getClientEndOffset() {
            return this.clientStartOffset + this.change.getText().length();
        }

        @NonNls
        public String toString() {
            return "client start offset: " + this.clientStartOffset + ", change: " + this.change;
        }
    }
}

