/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.editor.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.util.Processor;

public abstract class RedBlackTree<K> {
    public static boolean VERIFY = false;
    private int nodeSize;
    protected int modCount;
    protected Node<K> root = null;

    public RedBlackTree() {
        this.verifyProperties();
    }

    protected void rotateLeft(Node<K> n) {
        Node<K> r = n.getRight();
        this.replaceNode(n, r);
        n.setRight(r.getLeft());
        if (r.getLeft() != null) {
            r.getLeft().setParent(n);
        }
        r.setLeft(n);
        n.setParent(r);
    }

    protected void rotateRight(Node<K> n) {
        Node<K> l = n.getLeft();
        this.replaceNode(n, l);
        n.setLeft(l.getRight());
        if (l.getRight() != null) {
            l.getRight().setParent(n);
        }
        l.setRight(n);
        n.setParent(l);
    }

    protected void replaceNode(@NotNull Node<K> oldn, Node<K> newn) {
        if (oldn == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RedBlackTree.replaceNode must not be null");
        }
        Node<K> parent = oldn.getParent();
        if (parent == null) {
            this.root = newn;
        } else if (oldn == parent.getLeft()) {
            parent.setLeft(newn);
        } else {
            parent.setRight(newn);
        }
        if (newn != null) {
            newn.setParent(parent);
        }
    }

    protected void onInsertNode() {
        ++this.nodeSize;
    }

    protected void insertCase1(Node<K> n) {
        if (n.getParent() == null) {
            n.color = Color.BLACK;
        } else {
            this.insertCase2(n);
        }
    }

    private void insertCase2(Node<K> n) {
        if (RedBlackTree.nodeColor(n.getParent()) != Color.BLACK) {
            this.insertCase3(n);
        }
    }

    private void insertCase3(Node<K> n) {
        if (RedBlackTree.nodeColor(n.uncle()) == Color.RED) {
            n.getParent().color = Color.BLACK;
            n.uncle().color = Color.BLACK;
            n.grandparent().color = Color.RED;
            this.insertCase1(n.grandparent());
        } else {
            this.insertCase4(n);
        }
    }

    private void insertCase4(Node<K> n) {
        if (n == n.getParent().getRight() && n.getParent() == n.grandparent().getLeft()) {
            this.rotateLeft(n.getParent());
            n = n.getLeft();
        } else if (n == n.getParent().getLeft() && n.getParent() == n.grandparent().getRight()) {
            this.rotateRight(n.getParent());
            n = n.getRight();
        }
        this.insertCase5(n);
    }

    private void insertCase5(Node<K> n) {
        n.getParent().color = Color.BLACK;
        n.grandparent().color = Color.RED;
        if (n == n.getParent().getLeft() && n.getParent() == n.grandparent().getLeft()) {
            this.rotateRight(n.grandparent());
        } else {
            assert (n == n.getParent().getRight());
            assert (n.getParent() == n.grandparent().getRight());
            this.rotateLeft(n.grandparent());
        }
    }

    private static <K> void assertParentChild(Node<K> node1) {
        assert (node1 == null || node1.getParent() == null || node1.getParent().getLeft() == node1 || node1.getParent().getRight() == node1);
    }

    protected void deleteNode(@NotNull Node<K> n) {
        Node<K> child;
        if (n == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RedBlackTree.deleteNode must not be null");
        }
        ++this.modCount;
        Node<K> e = n;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        assert (e == this.root) : e;
        if (n.getLeft() != null && n.getRight() != null) {
            Node<K> pred = this.maximumNode(n.getLeft());
            n = this.swapWithMaxPred(n, pred);
        }
        assert (n.getLeft() == null || n.getRight() == null);
        Node<K> node = child = n.getRight() == null ? n.getLeft() : n.getRight();
        if (RedBlackTree.nodeColor(n) == Color.BLACK) {
            n.color = RedBlackTree.nodeColor(child);
            this.deleteCase1(n);
        }
        this.replaceNode(n, child);
        if (RedBlackTree.nodeColor(this.root) == Color.RED) {
            this.root.color = Color.BLACK;
        }
        assert (this.nodeSize > 0) : this.nodeSize;
        --this.nodeSize;
        this.verifyProperties();
    }

    protected abstract Node<K> swapWithMaxPred(Node<K> var1, Node<K> var2);

    protected Node<K> maximumNode(Node<K> n) {
        assert (n != null);
        while (n.getRight() != null) {
            n = n.getRight();
        }
        return n;
    }

    private void deleteCase1(Node<K> n) {
        if (n.getParent() != null) {
            this.deleteCase2(n);
        }
    }

    private void deleteCase2(Node<K> n) {
        if (RedBlackTree.nodeColor(n.sibling()) == Color.RED) {
            n.getParent().color = Color.RED;
            n.sibling().color = Color.BLACK;
            if (n == n.getParent().getLeft()) {
                this.rotateLeft(n.getParent());
            } else {
                this.rotateRight(n.getParent());
            }
        }
        this.deleteCase3(n);
    }

    private void deleteCase3(Node<K> n) {
        if (RedBlackTree.nodeColor(n.getParent()) == Color.BLACK && RedBlackTree.nodeColor(n.sibling()) == Color.BLACK && RedBlackTree.nodeColor(n.sibling().getLeft()) == Color.BLACK && RedBlackTree.nodeColor(n.sibling().getRight()) == Color.BLACK) {
            n.sibling().color = Color.RED;
            this.deleteCase1(n.getParent());
        } else {
            this.deleteCase4(n);
        }
    }

    private void deleteCase4(Node<K> n) {
        if (RedBlackTree.nodeColor(n.getParent()) == Color.RED && RedBlackTree.nodeColor(n.sibling()) == Color.BLACK && RedBlackTree.nodeColor(n.sibling().getLeft()) == Color.BLACK && RedBlackTree.nodeColor(n.sibling().getRight()) == Color.BLACK) {
            n.sibling().color = Color.RED;
            n.getParent().color = Color.BLACK;
        } else {
            this.deleteCase5(n);
        }
    }

    private void deleteCase5(Node<K> n) {
        if (n == n.getParent().getLeft() && RedBlackTree.nodeColor(n.sibling()) == Color.BLACK && RedBlackTree.nodeColor(n.sibling().getLeft()) == Color.RED && RedBlackTree.nodeColor(n.sibling().getRight()) == Color.BLACK) {
            n.sibling().color = Color.RED;
            n.sibling().getLeft().color = Color.BLACK;
            this.rotateRight(n.sibling());
        } else if (n == n.getParent().getRight() && RedBlackTree.nodeColor(n.sibling()) == Color.BLACK && RedBlackTree.nodeColor(n.sibling().getRight()) == Color.RED && RedBlackTree.nodeColor(n.sibling().getLeft()) == Color.BLACK) {
            n.sibling().color = Color.RED;
            n.sibling().getRight().color = Color.BLACK;
            this.rotateLeft(n.sibling());
        }
        this.deleteCase6(n);
    }

    private void deleteCase6(Node<K> n) {
        n.sibling().color = RedBlackTree.nodeColor(n.getParent());
        n.getParent().color = Color.BLACK;
        if (n == n.getParent().getLeft()) {
            assert (RedBlackTree.nodeColor(n.sibling().getRight()) == Color.RED);
            n.sibling().getRight().color = Color.BLACK;
            this.rotateLeft(n.getParent());
        } else {
            assert (RedBlackTree.nodeColor(n.sibling().getLeft()) == Color.RED);
            n.sibling().getLeft().color = Color.BLACK;
            this.rotateRight(n.getParent());
        }
    }

    public void print() {
        RedBlackTree.printHelper(this.root, 0);
    }

    private static void printHelper(Node<?> n, int indent) {
        if (n == null) {
            System.err.print("<empty tree>");
            return;
        }
        if (n.getRight() != null) {
            RedBlackTree.printHelper(n.getRight(), indent + 4);
        }
        for (int i = 0; i < indent; ++i) {
            System.err.print(" ");
        }
        if (n.color == Color.BLACK) {
            System.err.println(n);
        } else {
            System.err.println("<" + n + ">");
        }
        if (n.getLeft() != null) {
            RedBlackTree.printHelper(n.getLeft(), indent + 4);
        }
    }

    public int size() {
        return this.nodeSize;
    }

    public int nodeSize() {
        return this.nodeSize;
    }

    public void verifyProperties() {
        if (VERIFY) {
            RedBlackTree.verifyProperty1(this.root);
            RedBlackTree.verifyProperty2(this.root);
            RedBlackTree.verifyProperty4(this.root);
            RedBlackTree.verifyProperty5(this.root);
        }
    }

    private static void verifyProperty1(Node<?> n) {
        assert (RedBlackTree.nodeColor(n) == Color.RED || RedBlackTree.nodeColor(n) == Color.BLACK);
        if (n == null) {
            return;
        }
        assert (n.getParent() != n);
        assert (n.getLeft() != n);
        assert (n.getRight() != n);
        RedBlackTree.assertParentChild(n);
        RedBlackTree.verifyProperty1(n.getLeft());
        RedBlackTree.verifyProperty1(n.getRight());
    }

    private static void verifyProperty2(Node<?> root) {
        assert (RedBlackTree.nodeColor(root) == Color.BLACK);
    }

    private static Color nodeColor(Node<?> n) {
        return n == null ? Color.BLACK : n.color;
    }

    private static void verifyProperty4(Node<?> n) {
        if (RedBlackTree.nodeColor(n) == Color.RED) {
            assert (RedBlackTree.nodeColor(n.getLeft()) == Color.BLACK);
            assert (RedBlackTree.nodeColor(n.getRight()) == Color.BLACK);
            assert (RedBlackTree.nodeColor(n.getParent()) == Color.BLACK);
        }
        if (n == null) {
            return;
        }
        RedBlackTree.verifyProperty4(n.getLeft());
        RedBlackTree.verifyProperty4(n.getRight());
    }

    private static void verifyProperty5(Node<?> root) {
        RedBlackTree.verifyProperty5Helper(root, 0, -1);
    }

    private static int verifyProperty5Helper(Node<?> n, int blackCount, int pathBlackCount) {
        if (RedBlackTree.nodeColor(n) == Color.BLACK) {
            ++blackCount;
        }
        if (n == null) {
            if (pathBlackCount == -1) {
                pathBlackCount = blackCount;
            } else assert (blackCount == pathBlackCount);
            return pathBlackCount;
        }
        pathBlackCount = RedBlackTree.verifyProperty5Helper(n.getLeft(), blackCount, pathBlackCount);
        pathBlackCount = RedBlackTree.verifyProperty5Helper(n.getRight(), blackCount, pathBlackCount);
        return pathBlackCount;
    }

    public void clear() {
        ++this.modCount;
        this.root = null;
        this.nodeSize = 0;
    }

    protected static enum Color {
        RED,
        BLACK;

    }

    public static abstract class Node<K> {
        protected Node<K> left;
        protected Node<K> right;
        protected Node<K> parent = null;
        protected Color color = Color.RED;

        public Node<K> grandparent() {
            assert (this.getParent() != null);
            assert (this.getParent().getParent() != null);
            return this.getParent().getParent();
        }

        public Node<K> sibling() {
            Node<K> parent = this.getParent();
            assert (parent != null);
            return this == parent.getLeft() ? parent.getRight() : parent.getLeft();
        }

        public Node<K> uncle() {
            assert (this.getParent() != null);
            assert (this.getParent().getParent() != null);
            return this.getParent().sibling();
        }

        public Node<K> getLeft() {
            return this.left;
        }

        public void setLeft(Node<K> left) {
            this.left = left;
        }

        public Node<K> getRight() {
            return this.right;
        }

        public void setRight(Node<K> right) {
            this.right = right;
        }

        public Node<K> getParent() {
            return this.parent;
        }

        public void setParent(Node<K> parent) {
            this.parent = parent;
        }

        public abstract boolean processAliveKeys(@NotNull Processor<? super K> var1);

        public abstract boolean hasAliveKey(boolean var1);
    }
}

