/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.editor.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.Document;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.ex.RangeMarkerEx;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.ex.SweepProcessor;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.impl.IntervalTreeImpl;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.impl.RangeMarkerImpl;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.impl.RedBlackTree;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Getter;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Segment;
import org.jetbrains.jet.internal.com.intellij.util.Processor;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.RangeMarkerTree");
    private static final boolean DEBUG = LOG.isDebugEnabled() || ApplicationManager.getApplication() != null && (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal());
    private final PrioritizedDocumentListener myListener;
    private final Document myDocument;

    protected RangeMarkerTree(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.<init> must not be null");
        }
        this.myDocument = document;
        this.myListener = new PrioritizedDocumentListener(){

            @Override
            public int getPriority() {
                return 40;
            }

            @Override
            public void beforeDocumentChange(DocumentEvent event) {
            }

            @Override
            public void documentChanged(DocumentEvent e) {
                RangeMarkerTree.this.updateMarkersOnChange(e);
            }
        };
        document.addDocumentListener(this.myListener);
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        if (i1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.compareEqualStartIntervals must not be null");
        }
        if (i2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.compareEqualStartIntervals must not be null");
        }
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        return 0;
    }

    public void dispose() {
        this.myDocument.removeDocumentListener(this.myListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMNode addInterval(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (interval == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.addInterval must not be null");
        }
        RangeMarkerImpl marker = (RangeMarkerImpl)interval;
        marker.setValid(true);
        RMNode node = (RMNode)super.addInterval(interval, start, end, greedyToLeft, greedyToRight, layer);
        if (DEBUG && node.intervals.size() > 30) {
            this.l.readLock().lock();
            try {
                String msg = this.errMsg(node);
                if (msg != null) {
                    System.gc();
                    System.gc();
                    System.gc();
                    msg = this.errMsg(node);
                    if (msg != null) {
                        LOG.error(msg);
                    }
                }
            }
            finally {
                this.l.readLock().unlock();
            }
        }
        return node;
    }

    private String errMsg(RMNode node) {
        final StringBuilder msg = new StringBuilder();
        final AtomicInteger alive = new AtomicInteger();
        node.processAliveKeys(new Processor<Object>(){

            @Override
            public boolean process(Object t) {
                msg.append(t).append("\n");
                alive.incrementAndGet();
                return true;
            }
        });
        if (alive.get() > 30) {
            msg.insert(0, "Too many range markers (" + alive + ") registered in " + this + ":\n");
            return msg.toString();
        }
        return null;
    }

    @NotNull
    protected RMNode createNewNode(@NotNull T key, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.createNewNode must not be null");
        }
        RMNode rMNode = new RMNode(this, key, start, end, greedyToLeft, greedyToRight);
        if (rMNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/RangeMarkerTree.createNewNode must not return null");
        }
        return rMNode;
    }

    @Override
    protected void checkBelongsToTheTree(T interval, boolean assertInvalid) {
        assert (((RangeMarkerImpl)interval).myDocument == this.myDocument);
        super.checkBelongsToTheTree(interval, assertInvalid);
    }

    protected RMNode lookupNode(@NotNull T key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.lookupNode must not be null");
        }
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.setNode must not be null");
        }
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkersOnChange(DocumentEvent e) {
        try {
            this.l.writeLock().lock();
            if (this.size() == 0) {
                return;
            }
            this.checkMax(true);
            ++this.modCount;
            SmartList<IntervalTreeImpl.IntervalNode<T>> affected = new SmartList<IntervalTreeImpl.IntervalNode<T>>();
            this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), e, affected, new IntervalTreeImpl.NodeCachedOffsets());
            this.checkMax(false);
            if (!affected.isEmpty()) {
                for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                    int startOffset = intervalNode.intervalStart();
                    int endOffset = intervalNode.intervalEnd();
                    this.removeNode(intervalNode);
                    this.checkMax(false);
                    intervalNode.clearDelta();
                    intervalNode.setParent(null);
                    intervalNode.setLeft(null);
                    intervalNode.setRight(null);
                    intervalNode.setValid(true);
                    assert (intervalNode.intervalStart() == startOffset);
                    assert (intervalNode.intervalEnd() == endOffset);
                }
                this.checkMax(true);
                for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                    List keys = intervalNode.intervals;
                    if (keys.isEmpty()) continue;
                    RangeMarkerImpl marker = null;
                    for (int i = keys.size() - 1; i >= 0; --i) {
                        Getter key = keys.get(i);
                        marker = (RangeMarkerImpl)key.get();
                        if (marker == null) continue;
                        if (marker.isValid()) break;
                        intervalNode.removeIntervalInternal(i);
                        marker = null;
                    }
                    if (marker == null) continue;
                    marker.documentChanged(e);
                    if (marker.isValid()) {
                        RMNode insertedNode = (RMNode)this.findOrInsert(intervalNode);
                        if (insertedNode != intervalNode) {
                            for (Getter key : keys) {
                                RangeMarkerEx interval = (RangeMarkerEx)key.get();
                                if (interval == null) continue;
                                insertedNode.addInterval(interval);
                            }
                        }
                        assert (marker.isValid());
                        continue;
                    }
                    intervalNode.setValid(false);
                }
            }
            this.checkMax(true);
            IntervalTreeImpl.IntervalNode root = this.getRoot();
            assert (root == null || root.maxEnd + root.delta <= this.myDocument.getTextLength());
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private boolean collectAffectedMarkersAndShiftSubtrees(IntervalTreeImpl.IntervalNode<T> root, @NotNull DocumentEvent e, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected, IntervalTreeImpl.NodeCachedOffsets cached) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.collectAffectedMarkersAndShiftSubtrees must not be null");
        }
        if (affected == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.collectAffectedMarkersAndShiftSubtrees must not be null");
        }
        if (root == null) {
            return true;
        }
        boolean norm = this.pushDelta(root, cached);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        int offset = e.getOffset();
        int affectedEndOffset = offset + e.getOldLength();
        boolean hasAliveKeys = root.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root);
        }
        if (offset <= maxEnd) {
            if (affectedEndOffset < root.intervalStart()) {
                int lengthDelta = e.getNewLength() - e.getOldLength();
                int newD = root.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root, cached);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, e, affected, cached);
                this.correctMax(root, 0);
            } else {
                if (offset <= root.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root);
                    }
                    root.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), e, affected, cached);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getRight(), e, affected, cached);
                this.correctMax(root, 0);
            }
        }
        return norm;
    }

    public boolean sweep(final int start, final int end, @NotNull SweepProcessor<T> sweepProcessor) {
        if (sweepProcessor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.sweep must not be null");
        }
        return RangeMarkerTree.sweep(new Generator<T>(){

            @Override
            public boolean generate(Processor<T> processor) {
                return RangeMarkerTree.this.processOverlappingWith(start, end, processor);
            }
        }, sweepProcessor);
    }

    public static <T extends Segment> boolean sweep(@NotNull Generator<T> generator, final @NotNull SweepProcessor<T> sweepProcessor) {
        if (generator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.sweep must not be null");
        }
        if (sweepProcessor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree.sweep must not be null");
        }
        final PriorityQueue ends = new PriorityQueue(5, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getEndOffset() - o2.getEndOffset();
            }
        });
        final ArrayList starts = new ArrayList();
        if (!generator.generate(new Processor<T>(){

            @Override
            public boolean process(T marker) {
                int start;
                block4: {
                    boolean removed;
                    start = marker.getStartOffset();
                    while (true) {
                        int prevEnd;
                        assert (ends.size() == starts.size());
                        Segment previous = (Segment)ends.peek();
                        if (previous == null || (prevEnd = previous.getEndOffset()) > start) break block4;
                        if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                            return false;
                        }
                        ends.remove();
                        removed = starts.remove(previous);
                        assert (removed);
                    }
                }
                if (!sweepProcessor.process(start, marker, true, ends)) {
                    return false;
                }
                starts.add(marker);
                ends.offer(marker);
                return true;
            }
        })) {
            return false;
        }
        while (!ends.isEmpty()) {
            assert (ends.size() == starts.size());
            Segment previous = (Segment)ends.remove();
            int prevEnd = previous.getEndOffset();
            if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                return false;
            }
            boolean removed = starts.remove(previous);
            assert (removed);
        }
        return true;
    }

    public static interface Generator<T> {
        public boolean generate(Processor<T> var1);
    }

    public class RMNode
    extends IntervalTreeImpl.IntervalNode<T> {
        private final boolean isExpandToLeft;
        private final boolean isExpandToRight;
        final /* synthetic */ RangeMarkerTree this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public RMNode(@NotNull T key, int start, int end, boolean greedyToLeft, boolean greedyToRight) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerTree$RMNode.<init> must not be null");
            }
            this.this$0 = (RangeMarkerTree)n;
            super(n, key, start, end);
            this.isExpandToLeft = greedyToLeft;
            this.isExpandToRight = greedyToRight;
        }

        public boolean isGreedyToLeft() {
            return this.isExpandToLeft;
        }

        public boolean isGreedyToRight() {
            return this.isExpandToRight;
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }
    }
}

