/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.editor.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.RangeMarker;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.impl.event.DocumentEventImpl;

public class PersistentRangeMarkerUtil {
    private PersistentRangeMarkerUtil() {
    }

    public static boolean shouldTranslateViaDiff(@NotNull DocumentEventImpl e, @NotNull RangeMarker rangeMarker) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/PersistentRangeMarkerUtil.shouldTranslateViaDiff must not be null");
        }
        if (rangeMarker == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/PersistentRangeMarkerUtil.shouldTranslateViaDiff must not be null");
        }
        if (e.isWholeTextReplaced()) {
            return true;
        }
        if (!rangeMarker.isValid()) {
            return false;
        }
        if (e.getOffset() >= rangeMarker.getEndOffset() || e.getOffset() + e.getOldLength() <= rangeMarker.getStartOffset()) {
            return false;
        }
        return (double)Math.max(e.getNewLength(), e.getOldLength()) * 1.0 / (double)e.getDocument().getTextLength() >= 0.8;
    }
}

