/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.diff.impl;

import org.jetbrains.jet.internal.com.intellij.CommonBundle;
import org.jetbrains.jet.internal.com.intellij.openapi.diff.ex.DiffFragment;
import org.jetbrains.jet.internal.com.intellij.openapi.diff.impl.DiffFragmentBuilder;
import org.jetbrains.jet.internal.com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import org.jetbrains.jet.internal.com.intellij.openapi.diff.impl.highlighting.Util;
import org.jetbrains.jet.internal.com.intellij.openapi.diff.impl.processing.DiffCorrection;
import org.jetbrains.jet.internal.com.intellij.openapi.diff.impl.processing.Formatting;
import org.jetbrains.jet.internal.com.intellij.openapi.diff.impl.processing.Word;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.util.diff.Diff;
import org.jetbrains.jet.internal.com.intellij.util.diff.FilesTooBigForDiffException;

public abstract class ComparisonPolicy {
    private final String myName;
    public static final ComparisonPolicy DEFAULT = new ComparisonPolicy(CommonBundle.message("comparison.policy.default.name", new Object[0])){

        @Override
        protected Object[] getWrappers(String[] strings) {
            return strings;
        }

        @Override
        protected Object[] getLineWrappers(String[] lines) {
            return lines;
        }

        @Override
        public DiffFragment createFragment(Word word1, Word word2) {
            return this.createFragment(word1.getText(), word2.getText());
        }

        public String toString() {
            return "DEFAULT";
        }
    };
    public static final ComparisonPolicy TRIM_SPACE = new ComparisonPolicy(CommonBundle.message("comparison.policy.trim.space.name", new Object[0])){

        @Override
        protected Object[] getLineWrappers(String[] lines) {
            return this.trimStrings(lines);
        }

        @Override
        public DiffFragment createFragment(Word word1, Word word2) {
            String text1 = word1.getText();
            String text2 = word2.getText();
            if (word1.isWhitespace() && word2.isWhitespace() && word1.atEndOfLine() && word2.atEndOfLine()) {
                return DiffFragment.unchanged(text1, text2);
            }
            return this.createFragment(text1, text2);
        }

        @Override
        protected Object[] getWrappers(String[] strings) {
            Object[] result = new Object[strings.length];
            boolean atBeginning = true;
            for (int i = 0; i < strings.length; ++i) {
                String wrapper;
                String string = strings[i];
                String string2 = wrapper = atBeginning ? StringUtil.trimLeading(string) : string;
                if (StringUtil.endsWithChar(wrapper, '\n')) {
                    atBeginning = true;
                    wrapper = StringUtil.trimTrailing(wrapper);
                } else {
                    atBeginning = false;
                }
                result[i] = wrapper;
            }
            return result;
        }

        public String toString() {
            return "TRIM";
        }
    };
    public static final ComparisonPolicy IGNORE_SPACE = new IgnoreSpacePolicy();
    public static final ComparisonPolicy[] COMPARISON_POLICIES = new ComparisonPolicy[]{DEFAULT, IGNORE_SPACE, TRIM_SPACE};

    protected ComparisonPolicy(String name) {
        this.myName = name;
    }

    public DiffFragment[] buildFragments(String[] strings1, String[] strings2) throws FilesTooBigForDiffException {
        DiffFragmentBuilder builder = new DiffFragmentBuilder(strings1, strings2);
        Object[] wrappers1 = this.getWrappers(strings1);
        Object[] wrappers2 = this.getWrappers(strings2);
        Diff.Change change = Diff.buildChanges(wrappers1, wrappers2);
        return builder.buildFragments(Util.concatEquals(change, wrappers1, wrappers2));
    }

    public DiffFragment[] buildDiffFragmentsFromLines(String[] lines1, String[] lines2) throws FilesTooBigForDiffException {
        DiffFragmentBuilder builder = new DiffFragmentBuilder(lines1, lines2);
        Object[] wrappers1 = this.getLineWrappers(lines1);
        Object[] wrappers2 = this.getLineWrappers(lines2);
        Diff.Change change = Diff.buildChanges(wrappers1, wrappers2);
        return builder.buildFragments(change);
    }

    private static String toNotNull(String text) {
        return text == null ? "" : text;
    }

    protected abstract Object[] getWrappers(String[] var1);

    protected abstract Object[] getLineWrappers(String[] var1);

    protected Object[] trimStrings(String[] strings) {
        Object[] result = new Object[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            result[i] = string.trim();
        }
        return result;
    }

    public DiffFragment createFragment(String text1, String text2) {
        text1 = this.toNull(text1);
        text2 = this.toNull(text2);
        if (text1 == null && text2 == null) {
            return new DiffFragment("", "");
        }
        DiffFragment result = new DiffFragment(text1, text2);
        if (text1 != null && text2 != null) {
            result.setModified(!this.getWrapper(text1).equals(this.getWrapper(text2)));
        }
        return result;
    }

    private String toNull(String text1) {
        return text1 == null || text1.length() == 0 ? null : text1;
    }

    private Object getWrapper(String text) {
        return this.getWrappers(new String[]{text})[0];
    }

    public boolean isEqual(DiffFragment fragment) {
        if (fragment.isOneSide()) {
            return false;
        }
        Object[] wrappers = this.getLineWrappers(new String[]{fragment.getText1(), fragment.getText2()});
        return Comparing.equal(wrappers[0], wrappers[1]);
    }

    public Word createFormatting(String text, TextRange textRange) {
        return new Formatting(text, textRange);
    }

    public abstract DiffFragment createFragment(Word var1, Word var2);

    public String getName() {
        return this.myName;
    }

    public static ComparisonPolicy[] getAllInstances() {
        return COMPARISON_POLICIES;
    }

    private static class IgnoreSpacePolicy
    extends ComparisonPolicy
    implements DiffCorrection.FragmentProcessor<DiffCorrection.FragmentsCollector> {
        public IgnoreSpacePolicy() {
            super(CommonBundle.message("comparison.policy.ignore.spaces.name", new Object[0]));
        }

        @Override
        protected Object[] getLineWrappers(String[] lines) {
            Object[] result = new Object[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                result[i] = this.getWrapper(line);
            }
            return result;
        }

        @Override
        public DiffFragment[] buildFragments(String[] strings1, String[] strings2) throws FilesTooBigForDiffException {
            DiffFragment[] fragments = super.buildFragments(strings1, strings2);
            DiffCorrection.FragmentsCollector collector = new DiffCorrection.FragmentsCollector();
            collector.processAll(fragments, this);
            return collector.toArray();
        }

        @Override
        private Object getWrapper(String line) {
            line = line.trim();
            char[] chars = new char[line.length()];
            line.getChars(0, line.length(), chars, 0);
            char[] result = new char[chars.length];
            int resultLength = 0;
            for (int i = 0; i < chars.length; ++i) {
                char aChar = chars[i];
                if (Character.isWhitespace(aChar)) continue;
                result[resultLength] = aChar;
                ++resultLength;
            }
            return new String(result, 0, resultLength);
        }

        @Override
        public DiffFragment createFragment(Word word1, Word word2) {
            String text1 = word1.getText();
            String text2 = word2.getText();
            return word1.isWhitespace() && word2.isWhitespace() ? DiffFragment.unchanged(text1, text2) : this.createFragment(text1, text2);
        }

        @Override
        public DiffFragment createFragment(String text1, String text2) {
            String toCompare1 = ComparisonPolicy.toNotNull(text1);
            String toCompare2 = ComparisonPolicy.toNotNull(text2);
            if (this.getWrapper(toCompare1).equals(this.getWrapper(toCompare2))) {
                return DiffFragment.unchanged(toCompare1, toCompare2);
            }
            return new DiffFragment(text1, text2);
        }

        @Override
        protected Object[] getWrappers(String[] strings) {
            return this.trimStrings(strings);
        }

        public String toString() {
            return "IGNORE";
        }

        @Override
        public void process(DiffFragment fragment, DiffCorrection.FragmentsCollector collector) {
            FragmentSide side;
            String text;
            String trimed;
            if (fragment.isEqual()) {
                collector.add(fragment);
                return;
            }
            if (fragment.isOneSide() && (trimed = (text = (side = FragmentSide.chooseSide(fragment)).getText(fragment)).trim()).length() == 0) {
                collector.add(side.createFragment(text, "", false));
                return;
            }
            collector.add(fragment);
        }
    }
}

