/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.diagnostic;

import java.util.ArrayList;
import java.util.List;

public class Log {
    private static final List<String> myStrings = new ArrayList<String>();
    private static final List<Throwable> myThrowables = new ArrayList<Throwable>();
    private static final Object LOCK = new Object();

    private Log() {
    }

    public static void print(String text) {
        Log.print(text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String text, boolean trace) {
        Object object = LOCK;
        synchronized (object) {
            myStrings.add(text);
            myThrowables.add(trace ? new Exception() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        Object object = LOCK;
        synchronized (object) {
            for (int i = 0; i < myStrings.size(); ++i) {
                String each = myStrings.get(i);
                Throwable trace = myThrowables.get(i);
                System.out.println(each);
                if (trace == null) continue;
                trace.printStackTrace(System.out);
            }
            myStrings.clear();
            myThrowables.clear();
        }
    }
}

