/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.components.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.diagnostic.PluginException;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.components.BaseComponent;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ComponentConfig;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ComponentManager;
import org.jetbrains.jet.internal.com.intellij.openapi.components.NamedComponent;
import org.jetbrains.jet.internal.com.intellij.openapi.components.StateStorageException;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ex.ComponentManagerEx;
import org.jetbrains.jet.internal.com.intellij.openapi.components.impl.ComponentManagerConfigurator;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Condition;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.ReflectionCache;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentHashMap;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBus;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBusFactory;
import org.jetbrains.jet.internal.com.intellij.util.pico.IdeaPicoContainer;
import org.jetbrains.jet.internal.gnu.trove.THashMap;
import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.MutablePicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoInitializationException;
import org.jetbrains.jet.internal.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.jet.internal.org.picocontainer.PicoVisitor;
import org.jetbrains.jet.internal.org.picocontainer.defaults.CachingComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public abstract class ComponentManagerImpl
extends UserDataHolderBase
implements ComponentManagerEx,
org.jetbrains.jet.internal.org.picocontainer.Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.components.ComponentManager");
    private final Map<Class, Object> myInitializedComponents = new ConcurrentHashMap<Class, Object>();
    private boolean myComponentsCreated = false;
    private MutablePicoContainer myPicoContainer;
    private volatile boolean myDisposed = false;
    private volatile boolean myDisposeCompleted = false;
    private MessageBus myMessageBus;
    private final ComponentManagerConfigurator myConfigurator = new ComponentManagerConfigurator(this);
    private final ComponentManager myParentComponentManager;
    private Boolean myHeadless;
    protected ComponentsRegistry myComponentsRegistry = new ComponentsRegistry();
    private final Condition myDisposedCondition = new Condition(){

        public boolean value(Object o) {
            return ComponentManagerImpl.this.isDisposed();
        }
    };
    protected volatile boolean temporarilyDisposed = false;

    protected ComponentManagerImpl(ComponentManager parentComponentManager) {
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer();
    }

    public void init() {
        this.initComponents();
    }

    @Override
    public MessageBus getMessageBus() {
        assert (!this.myDisposeCompleted && !this.myDisposed) : "Already disposed";
        assert (this.myMessageBus != null) : "Not initialized yet";
        return this.myMessageBus;
    }

    public boolean isComponentsCreated() {
        return this.myComponentsCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createComponents() {
        try {
            Class[] componentInterfaces;
            this.myComponentsRegistry.loadClasses();
            for (Class componentInterface : componentInterfaces = this.myComponentsRegistry.getComponentInterfaces()) {
                ProgressIndicatorProvider.checkCanceled();
                try {
                    this.createComponent(componentInterface);
                }
                catch (StateStorageException e) {
                    throw e;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
        finally {
            this.myComponentsCreated = true;
        }
    }

    protected synchronized Object createComponent(Class componentInterface) {
        Object component = this.getPicoContainer().getComponentInstance(componentInterface.getName());
        LOG.assertTrue(component != null, "Can't instantiate component for: " + componentInterface);
        return component;
    }

    protected synchronized void disposeComponents() {
        assert (!this.myDisposeCompleted) : "Already disposed!";
        List<Object> components = this.myComponentsRegistry.getRegisteredImplementations();
        this.myDisposed = true;
        for (int i = components.size() - 1; i >= 0; --i) {
            Object component = components.get(i);
            if (!(component instanceof BaseComponent)) continue;
            try {
                ((BaseComponent)component).disposeComponent();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myComponentsCreated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected <T> T getComponentFromContainer(Class<T> interfaceClass) {
        Object initializedComponent = this.myInitializedComponents.get(interfaceClass);
        if (initializedComponent != null) {
            return (T)initializedComponent;
        }
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            Object lock;
            if (this.myComponentsRegistry == null || !this.myComponentsRegistry.containsInterface(interfaceClass)) {
                return null;
            }
            Object object = lock = this.myComponentsRegistry.getComponentLock(interfaceClass);
            synchronized (object) {
                Object dcl = this.myInitializedComponents.get(interfaceClass);
                if (dcl != null) {
                    return (T)dcl;
                }
                Object component = this.getPicoContainer().getComponentInstance(interfaceClass.getName());
                if (component == null) {
                    component = this.createComponent(interfaceClass);
                }
                if (component == null) {
                    throw new IncorrectOperationException("createComponent() returns null for: " + interfaceClass);
                }
                this.myInitializedComponents.put(interfaceClass, component);
                if (component instanceof Disposable) {
                    Disposer.register(this, (Disposable)component);
                }
                return (T)component;
            }
        }
    }

    @Override
    public <T> T getComponent(Class<T> interfaceClass) {
        assert (!this.myDisposeCompleted) : "Already disposed: " + this;
        return this.getComponent(interfaceClass, null);
    }

    @Override
    public <T> T getComponent(Class<T> interfaceClass, T defaultImplementation) {
        T fromContainer = this.getComponentFromContainer(interfaceClass);
        if (fromContainer != null) {
            return fromContainer;
        }
        if (defaultImplementation != null) {
            return defaultImplementation;
        }
        return null;
    }

    private void initComponent(Object component) {
        ProgressIndicator indicator = ComponentManagerImpl.getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
        }
        try {
            this.initializeComponent(component, false);
            if (component instanceof BaseComponent) {
                ((BaseComponent)component).initComponent();
            }
        }
        catch (StateStorageException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable ex) {
            this.handleInitComponentError(ex, false, component.getClass().getName());
        }
    }

    @Nullable
    protected static ProgressIndicator getProgressIndicator() {
        ProgressIndicatorProvider progressManager = ProgressIndicatorProvider.getInstance();
        return progressManager != null ? progressManager.getProgressIndicator() : null;
    }

    @Override
    public void initializeComponent(Object component, boolean service) {
    }

    protected void handleInitComponentError(Throwable ex, boolean fatal, String componentClassName) {
        LOG.error(ex);
    }

    @Override
    public synchronized void registerComponent(ComponentConfig config, PluginDescriptor pluginDescriptor) {
        if (!config.prepareClasses(this.isHeadless())) {
            return;
        }
        config.pluginDescriptor = pluginDescriptor;
        this.myComponentsRegistry.registerComponent(config);
    }

    public synchronized void registerComponentImplementation(Class componentKey, Class componentImplementation) {
        this.getPicoContainer().registerComponentImplementation(componentKey.getName(), componentImplementation);
        this.myInitializedComponents.remove(componentKey);
    }

    @Override
    public synchronized boolean hasComponent(@NotNull Class interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/ComponentManagerImpl.hasComponent must not be null");
        }
        return this.myComponentsRegistry.containsInterface(interfaceClass);
    }

    protected synchronized Object[] getComponents() {
        Class[] componentClasses = this.myComponentsRegistry.getComponentInterfaces();
        ArrayList components = new ArrayList(componentClasses.length);
        for (Class interfaceClass : componentClasses) {
            ProgressIndicatorProvider.checkCanceled();
            Object component = this.getComponent(interfaceClass);
            if (component == null) continue;
            components.add(component);
        }
        return ArrayUtil.toObjectArray(components);
    }

    @Override
    @NotNull
    public synchronized <T> T[] getComponents(Class<T> baseClass) {
        T[] TArray = this.myComponentsRegistry.getComponentsByType(baseClass);
        if (TArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/ComponentManagerImpl.getComponents must not return null");
        }
        return TArray;
    }

    @Override
    @NotNull
    public MutablePicoContainer getPicoContainer() {
        assert (!this.myDisposeCompleted) : "Already disposed";
        MutablePicoContainer mutablePicoContainer = this.myPicoContainer;
        if (mutablePicoContainer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/ComponentManagerImpl.getPicoContainer must not return null");
        }
        return mutablePicoContainer;
    }

    protected MutablePicoContainer createPicoContainer() {
        IdeaPicoContainer result = this.myParentComponentManager != null ? new IdeaPicoContainer(this.myParentComponentManager.getPicoContainer()) : new IdeaPicoContainer();
        return result;
    }

    @Override
    public synchronized BaseComponent getComponent(String name) {
        return this.myComponentsRegistry.getComponentByName(name);
    }

    protected boolean isComponentSuitable(Map<String, String> options) {
        return !ComponentManagerImpl.isTrue(options, "internal") || ApplicationManager.getApplication().isInternal();
    }

    private static boolean isTrue(Map<String, String> options, @NonNls String option) {
        return options != null && options.containsKey(option) && Boolean.valueOf(options.get(option)) != false;
    }

    @Override
    public synchronized void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDisposeCompleted = true;
        if (this.myMessageBus != null) {
            this.myMessageBus.dispose();
            this.myMessageBus = null;
        }
        this.myInitializedComponents.clear();
        this.myComponentsRegistry = null;
        this.myPicoContainer = null;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed || this.temporarilyDisposed;
    }

    public void setTemporarilyDisposed(boolean disposed) {
        this.temporarilyDisposed = disposed;
    }

    public void initComponents() {
        this.createComponents();
        this.getComponents();
    }

    protected void loadComponentsConfiguration(ComponentConfig[] components, @Nullable PluginDescriptor descriptor, boolean defaultProject) {
        this.myConfigurator.loadComponentsConfiguration(components, descriptor, defaultProject);
    }

    protected void bootstrapPicoContainer() {
        this.myPicoContainer = this.createPicoContainer();
        this.myMessageBus = MessageBusFactory.newMessageBus(this, this.myParentComponentManager == null ? null : this.myParentComponentManager.getMessageBus());
        MutablePicoContainer picoContainer = this.getPicoContainer();
        picoContainer.registerComponentInstance(MessageBus.class, this.myMessageBus);
    }

    protected ComponentManager getParentComponentManager() {
        return this.myParentComponentManager;
    }

    private boolean isHeadless() {
        if (this.myHeadless == null) {
            this.myHeadless = ApplicationManager.getApplication().isHeadlessEnvironment();
        }
        return this.myHeadless;
    }

    @Override
    public void registerComponent(ComponentConfig config) {
        this.registerComponent(config, null);
    }

    @NotNull
    public ComponentConfig[] getComponentConfigurations() {
        ComponentConfig[] componentConfigArray = this.myComponentsRegistry.getComponentConfigurations();
        if (componentConfigArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/ComponentManagerImpl.getComponentConfigurations must not return null");
        }
        return componentConfigArray;
    }

    @Nullable
    public Object getComponent(ComponentConfig componentConfig) {
        return this.getPicoContainer().getComponentInstance(componentConfig.getInterfaceClass());
    }

    public ComponentConfig getConfig(Class componentImplementation) {
        return this.myComponentsRegistry.getConfig(componentImplementation);
    }

    @Override
    @NotNull
    public Condition getDisposed() {
        Condition condition = this.myDisposedCondition;
        if (condition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/ComponentManagerImpl.getDisposed must not return null");
        }
        return condition;
    }

    public static String getComponentName(@NotNull Object component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/ComponentManagerImpl.getComponentName must not be null");
        }
        if (component instanceof NamedComponent) {
            return ((NamedComponent)component).getComponentName();
        }
        return component.getClass().getName();
    }

    protected boolean logSlowComponents() {
        return LOG.isDebugEnabled();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    private class ComponentConfigComponentAdapter
    implements ComponentAdapter {
        private final ComponentConfig myConfig;
        private ComponentAdapter myDelegate;
        private boolean myInitialized = false;
        private boolean myInitializing = false;

        public ComponentConfigComponentAdapter(ComponentConfig config) {
            this.myConfig = config;
        }

        @Override
        public Object getComponentKey() {
            return this.myConfig.getInterfaceClass();
        }

        @Override
        public Class getComponentImplementation() {
            return this.getDelegate().getComponentImplementation();
        }

        @Override
        public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
            return this.getDelegate().getComponentInstance(container);
        }

        @Override
        public void verify(PicoContainer container) throws PicoIntrospectionException {
            this.getDelegate().verify(container);
        }

        @Override
        public void accept(PicoVisitor visitor) {
            visitor.visitComponentAdapter(this);
            this.getDelegate().accept(visitor);
        }

        private ComponentAdapter getDelegate() {
            if (this.myDelegate == null) {
                final Object componentKey = this.getComponentKey();
                ClassLoader loader = this.myConfig.getClassLoader();
                Class<?> implementationClass = null;
                try {
                    implementationClass = Class.forName(this.myConfig.getImplementationClass(), true, loader);
                }
                catch (Exception e) {
                    String message = "Error while registering component: " + this.myConfig;
                    if (this.myConfig.pluginDescriptor != null) {
                        LOG.error(message, new PluginException(e, this.myConfig.pluginDescriptor.getPluginId()));
                    } else {
                        LOG.error(message, e);
                    }
                }
                catch (Error e) {
                    if (this.myConfig.pluginDescriptor != null) {
                        LOG.error(new PluginException(e, this.myConfig.pluginDescriptor.getPluginId()));
                    }
                    throw e;
                }
                assert (implementationClass != null);
                this.myDelegate = new CachingComponentAdapter(new ConstructorInjectionComponentAdapter(componentKey, implementationClass, null, true)){

                    @Override
                    public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException {
                        Object componentInstance = null;
                        try {
                            long startTime = ComponentConfigComponentAdapter.this.myInitialized ? 0L : System.nanoTime();
                            componentInstance = super.getComponentInstance(picoContainer);
                            if (!ComponentConfigComponentAdapter.this.myInitialized) {
                                if (ComponentConfigComponentAdapter.this.myInitializing) {
                                    if (((ComponentConfigComponentAdapter)ComponentConfigComponentAdapter.this).myConfig.pluginDescriptor != null) {
                                        LOG.error(new PluginException("Cyclic component initialization: " + componentKey, ((ComponentConfigComponentAdapter)ComponentConfigComponentAdapter.this).myConfig.pluginDescriptor.getPluginId()));
                                    } else {
                                        LOG.error(new Throwable("Cyclic component initialization: " + componentKey));
                                    }
                                }
                                ComponentConfigComponentAdapter.this.myInitializing = true;
                                ComponentManagerImpl.this.myComponentsRegistry.registerComponentInstance(componentInstance);
                                ComponentManagerImpl.this.initComponent(componentInstance);
                                long endTime = System.nanoTime();
                                long ms = (endTime - startTime) / 1000000L;
                                if (ms > 10L && ComponentManagerImpl.this.logSlowComponents()) {
                                    LOG.info(componentInstance.getClass().getName() + " initialized in " + ms + " ms");
                                }
                                ComponentConfigComponentAdapter.this.myInitializing = false;
                                ComponentConfigComponentAdapter.this.myInitialized = true;
                            }
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (StateStorageException e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            ComponentManagerImpl.this.handleInitComponentError(t, componentInstance == null, componentKey.toString());
                        }
                        return componentInstance;
                    }
                };
            }
            return this.myDelegate;
        }
    }

    protected class ComponentsRegistry {
        private final Map<Class, Object> myInterfaceToLockMap = new THashMap<Class, Object>();
        private final Map<Class, Class> myInterfaceToClassMap = new THashMap<Class, Class>();
        private final ArrayList<Class> myComponentInterfaces = new ArrayList();
        private final Map<String, BaseComponent> myNameToComponent = new THashMap<String, BaseComponent>();
        private final List<ComponentConfig> myComponentConfigs = new ArrayList<ComponentConfig>();
        private final List<Object> myImplementations = new ArrayList<Object>();
        private final Map<Class, ComponentConfig> myComponentClassToConfig = new THashMap<Class, ComponentConfig>();
        private boolean myClassesLoaded = false;

        protected ComponentsRegistry() {
        }

        private void loadClasses() {
            assert (!this.myClassesLoaded);
            for (ComponentConfig config : this.myComponentConfigs) {
                this.loadClasses(config);
            }
            this.myClassesLoaded = true;
        }

        private void loadClasses(ComponentConfig config) {
            ClassLoader loader = config.getClassLoader();
            try {
                Class<?> interfaceClass = Class.forName(config.getInterfaceClass(), true, loader);
                Class<?> implementationClass = Class.forName(config.getImplementationClass(), true, loader);
                if (this.myInterfaceToClassMap.get(interfaceClass) != null) {
                    throw new Error("ComponentSetup for component " + interfaceClass.getName() + " already registered");
                }
                ComponentManagerImpl.this.getPicoContainer().registerComponent(new ComponentConfigComponentAdapter(config));
                this.myInterfaceToClassMap.put(interfaceClass, implementationClass);
                this.myComponentClassToConfig.put(implementationClass, config);
                this.myComponentInterfaces.add(interfaceClass);
            }
            catch (Exception e) {
                String message = "Error while registering component: " + config;
                if (config.pluginDescriptor != null) {
                    LOG.error(message, new PluginException(e, config.pluginDescriptor.getPluginId()));
                } else {
                    LOG.error(message, e);
                }
            }
            catch (Error e) {
                if (config.pluginDescriptor != null) {
                    LOG.error(new PluginException(e, config.pluginDescriptor.getPluginId()));
                }
                throw e;
            }
        }

        private Object getComponentLock(Class componentClass) {
            Object lock = this.myInterfaceToLockMap.get(componentClass);
            if (lock == null) {
                lock = new Object();
                this.myInterfaceToLockMap.put(componentClass, lock);
            }
            return lock;
        }

        private Class[] getComponentInterfaces() {
            assert (this.myClassesLoaded);
            return this.myComponentInterfaces.toArray(new Class[this.myComponentInterfaces.size()]);
        }

        private boolean containsInterface(Class interfaceClass) {
            if (!this.myClassesLoaded) {
                this.loadClasses();
            }
            return this.myInterfaceToClassMap.containsKey(interfaceClass);
        }

        public double getPercentageOfComponentsLoaded() {
            return (double)this.myImplementations.size() / (double)this.myComponentConfigs.size();
        }

        private void registerComponentInstance(Object component) {
            this.myImplementations.add(component);
            if (component instanceof BaseComponent) {
                BaseComponent baseComponent = (BaseComponent)component;
                String componentName = baseComponent.getComponentName();
                if (this.myNameToComponent.containsKey(componentName)) {
                    BaseComponent loadedComponent = this.myNameToComponent.get(componentName);
                    if (!component.equals(loadedComponent)) {
                        LOG.error("Component name collision: " + componentName + " " + loadedComponent.getClass() + " and " + component.getClass());
                    }
                } else {
                    this.myNameToComponent.put(componentName, baseComponent);
                }
            }
        }

        public List<Object> getRegisteredImplementations() {
            return this.myImplementations;
        }

        private void registerComponent(ComponentConfig config) {
            this.myComponentConfigs.add(config);
            if (this.myClassesLoaded) {
                this.loadClasses(config);
            }
        }

        private BaseComponent getComponentByName(String name) {
            return this.myNameToComponent.get(name);
        }

        public <T> T[] getComponentsByType(Class<T> baseClass) {
            ArrayList array = new ArrayList();
            for (int i = 0; i < this.myComponentInterfaces.size(); ++i) {
                Class interfaceClass = this.myComponentInterfaces.get(i);
                Class implClass = this.myInterfaceToClassMap.get(interfaceClass);
                if (!ReflectionCache.isAssignable(baseClass, implClass)) continue;
                array.add(ComponentManagerImpl.this.getComponent(interfaceClass));
            }
            return array.toArray((Object[])Array.newInstance(baseClass, array.size()));
        }

        public ComponentConfig[] getComponentConfigurations() {
            return this.myComponentConfigs.toArray(new ComponentConfig[this.myComponentConfigs.size()]);
        }

        public ComponentConfig getConfig(Class componentImplementation) {
            return this.myComponentClassToConfig.get(componentImplementation);
        }
    }
}

