/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.components.impl;

import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoInitializationException;
import org.jetbrains.jet.internal.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DecoratingComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.LifecycleStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.NotConcreteRegistrationException;

public class CachingComponentAdapter
extends DecoratingComponentAdapter {
    private volatile Object cached;
    private boolean disposed = false;
    private boolean started = false;
    private final boolean delegateHasLifecylce;
    private final Object lock = new Object();

    public CachingComponentAdapter(ComponentAdapter delegate) {
        super(delegate);
        this.delegateHasLifecylce = delegate instanceof LifecycleStrategy && ((LifecycleStrategy)((Object)delegate)).hasLifecycle(delegate.getComponentImplementation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object o = this.cached;
        if (o != null) {
            return o;
        }
        Object object = this.lock;
        synchronized (object) {
            o = this.cached;
            if (o != null) {
                return o;
            }
            this.cached = o = super.getComponentInstance(container);
        }
        return o;
    }

    @Override
    public void start(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.start(this.getComponentInstance(container));
            this.started = true;
        }
    }

    @Override
    public void stop(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (!this.started) {
                throw new IllegalStateException("Not started");
            }
            this.stop(this.getComponentInstance(container));
            this.started = false;
        }
    }

    @Override
    public void dispose(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            this.dispose(this.getComponentInstance(container));
            this.disposed = true;
        }
    }

    @Override
    public boolean hasLifecycle() {
        return this.delegateHasLifecylce;
    }
}

