/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.components;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.annotations.MapAnnotation;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.annotations.Property;
import org.jetbrains.jet.internal.com.intellij.util.xmlb.annotations.Transient;

public class ComponentConfig {
    public static final ComponentConfig[] EMPTY_ARRAY = new ComponentConfig[0];
    protected String implementationClass;
    protected String interfaceClass;
    protected String headlessImplementationClass;
    protected boolean loadForDefaultProject;
    @Property(surroundWithTag=false)
    @MapAnnotation(surroundWithTag=false, entryTagName="option", keyAttributeName="name", valueAttributeName="value")
    public Map<String, String> options = new HashMap<String, String>();
    @Transient
    public PluginDescriptor pluginDescriptor;

    @Transient
    public ClassLoader getClassLoader() {
        return this.pluginDescriptor != null ? this.pluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
    }

    public String getImplementationClass() {
        return this.implementationClass;
    }

    public String getInterfaceClass() {
        return this.interfaceClass;
    }

    public String getHeadlessImplementationClass() {
        return this.headlessImplementationClass;
    }

    public boolean isLoadForDefaultProject() {
        return this.loadForDefaultProject;
    }

    public boolean prepareClasses(boolean headless) {
        if (headless && this.headlessImplementationClass != null) {
            if (StringUtil.isEmpty(this.headlessImplementationClass)) {
                return false;
            }
            this.setImplementationClass(this.headlessImplementationClass);
        }
        if (StringUtil.isEmpty(this.interfaceClass)) {
            this.setInterfaceClass(this.implementationClass);
        }
        return true;
    }

    public void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass == null ? null : implementationClass.trim();
    }

    public void setInterfaceClass(String interfaceClass) {
        this.interfaceClass = interfaceClass == null ? null : interfaceClass.trim();
    }

    public void setHeadlessImplementationClass(String headlessImplementationClass) {
        this.headlessImplementationClass = headlessImplementationClass == null ? null : headlessImplementationClass.trim();
    }

    public void setLoadForDefaultProject(boolean loadForDefaultProject) {
        this.loadForDefaultProject = loadForDefaultProject;
    }
}

