/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.application;

import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;

public abstract class ModalityState {
    @NotNull
    public static final ModalityState NON_MODAL;
    @Deprecated
    @NotNull
    public static final ModalityState NON_MMODAL;

    @NotNull
    public static ModalityState current() {
        ModalityState modalityState = ApplicationManager.getApplication().getCurrentModalityState();
        if (modalityState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/application/ModalityState.current must not return null");
        }
        return modalityState;
    }

    @NotNull
    public static ModalityState any() {
        ModalityState modalityState = ApplicationManager.getApplication().getAnyModalityState();
        if (modalityState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/application/ModalityState.any must not return null");
        }
        return modalityState;
    }

    @NotNull
    public static ModalityState stateForComponent(Component component) {
        ModalityState modalityState = ApplicationManager.getApplication().getModalityStateForComponent(component);
        if (modalityState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/application/ModalityState.stateForComponent must not return null");
        }
        return modalityState;
    }

    @NotNull
    public static ModalityState defaultModalityState() {
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        if (modalityState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/application/ModalityState.defaultModalityState must not return null");
        }
        return modalityState;
    }

    public abstract boolean dominates(@NotNull ModalityState var1);

    static {
        try {
            Class<?> ex = Class.forName("org.jetbrains.jet.internal.com.intellij.openapi.application.impl.ModalityStateEx");
            NON_MMODAL = NON_MODAL = (ModalityState)ex.newInstance();
            assert (NON_MODAL != null);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

