/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.navigation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentationProvider;
import org.jetbrains.jet.internal.com.intellij.navigation.NavigationItem;
import org.jetbrains.jet.internal.com.intellij.openapi.util.ClassExtension;

public class ItemPresentationProviders
extends ClassExtension<ItemPresentationProvider> {
    public static final ItemPresentationProviders INSTANCE = new ItemPresentationProviders();

    private ItemPresentationProviders() {
        super("org.jetbrains.jet.internal.com.intellij.itemPresentationProvider");
    }

    @Nullable
    public static <T extends NavigationItem> ItemPresentationProvider<T> getItemPresentationProvider(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/navigation/ItemPresentationProviders.getItemPresentationProvider must not be null");
        }
        ItemPresentationProvider provider = (ItemPresentationProvider)INSTANCE.forClass(element.getClass());
        return provider;
    }

    @Nullable
    public static ItemPresentation getItemPresentation(NavigationItem element) {
        ItemPresentationProvider<NavigationItem> provider = ItemPresentationProviders.getItemPresentationProvider(element);
        return provider != null ? provider.getPresentation(element) : null;
    }
}

