/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.mock;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.components.BaseComponent;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ComponentManager;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Condition;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBus;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBusFactory;
import org.jetbrains.jet.internal.com.intellij.util.pico.IdeaPicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.MutablePicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager {
    private final MessageBus myMessageBus;
    private final MutablePicoContainer myPicoContainer;
    private final Map<Class, Object> myComponents;

    public MockComponentManager(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockComponentManager.<init> must not be null");
        }
        this.myMessageBus = MessageBusFactory.newMessageBus(this);
        this.myComponents = new HashMap<Class, Object>();
        this.myPicoContainer = new IdeaPicoContainer(parent){

            @Override
            @Nullable
            public Object getComponentInstance(Object componentKey) {
                Object o = super.getComponentInstance(componentKey);
                if (o instanceof Disposable && o != MockComponentManager.this) {
                    Disposer.register(MockComponentManager.this, (Disposable)o);
                }
                return o;
            }
        };
        this.myPicoContainer.registerComponentInstance(this);
        Disposer.register(parentDisposable, this);
    }

    @Override
    public BaseComponent getComponent(String name) {
        return null;
    }

    public <T> void registerService(Class<T> serviceInterface, Class<? extends T> serviceImplementation) {
        this.myPicoContainer.unregisterComponent(serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation(serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(Class<T> serviceImplementation) {
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(Class<T> serviceInterface, T serviceImplementation) {
        this.myPicoContainer.registerComponentInstance(serviceInterface.getName(), serviceImplementation);
    }

    public <T> void addComponent(Class<T> interfaceClass, T instance) {
        this.myComponents.put(interfaceClass, instance);
    }

    @Override
    public <T> T getComponent(Class<T> interfaceClass) {
        Object o = this.myPicoContainer.getComponentInstance(interfaceClass);
        return (T)(o != null ? o : this.myComponents.get(interfaceClass));
    }

    @Override
    public <T> T getComponent(Class<T> interfaceClass, T defaultImplementation) {
        return this.getComponent(interfaceClass);
    }

    @Override
    public boolean hasComponent(@NotNull Class interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockComponentManager.hasComponent must not be null");
        }
        return false;
    }

    @Override
    @NotNull
    public <T> T[] getComponents(Class<T> baseClass) {
        List list = this.myPicoContainer.getComponentInstancesOfType(baseClass);
        Object[] objectArray = list.toArray((Object[])Array.newInstance(baseClass, 0));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockComponentManager.getComponents must not return null");
        }
        return objectArray;
    }

    @Override
    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer mutablePicoContainer = this.myPicoContainer;
        if (mutablePicoContainer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockComponentManager.getPicoContainer must not return null");
        }
        return mutablePicoContainer;
    }

    @Override
    public MessageBus getMessageBus() {
        return this.myMessageBus;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public <T> T[] getExtensions(ExtensionPointName<T> extensionPointName) {
        throw new UnsupportedOperationException("getExtensions()");
    }

    @Override
    @NotNull
    public Condition getDisposed() {
        Condition condition = Condition.FALSE;
        if (condition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockComponentManager.getDisposed must not return null");
        }
        return condition;
    }
}

