/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.lang.properties.charset;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.jetbrains.jet.internal.com.intellij.lang.properties.charset.Native2AsciiCharset;

class Native2AsciiCharsetDecoder
extends CharsetDecoder {
    private final StringBuffer myOutBuffer = new StringBuffer();
    private final Charset myBaseCharset;

    public Native2AsciiCharsetDecoder(Native2AsciiCharset charset) {
        super(charset, 1.0f, 6.0f);
        this.myBaseCharset = charset.getBaseCharset();
    }

    @Override
    protected void implReset() {
        super.implReset();
        this.myOutBuffer.setLength(0);
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        return this.doFlush(out);
    }

    private CoderResult doFlush(CharBuffer out) {
        if (this.myOutBuffer.length() != 0) {
            int remaining = out.remaining();
            int outlen = Math.min(remaining, this.myOutBuffer.length());
            out.put(this.myOutBuffer.toString().substring(0, outlen).toCharArray());
            this.myOutBuffer.delete(0, outlen);
            if (this.myOutBuffer.length() != 0) {
                return CoderResult.OVERFLOW;
            }
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        try {
            CoderResult coderResult = this.doFlush(out);
            if (coderResult == CoderResult.OVERFLOW) {
                return CoderResult.OVERFLOW;
            }
            int start = in.position();
            byte[] buf = new byte[4];
            while (in.position() < in.limit()) {
                in.mark();
                byte b = in.get();
                if (b != 92) continue;
                this.decodeArray(in.array(), start, in.position() - 1);
                byte next = in.get();
                if (next == 117) {
                    buf[0] = in.get();
                    buf[1] = in.get();
                    buf[2] = in.get();
                    buf[3] = in.get();
                    char decoded = Native2AsciiCharsetDecoder.unicode(buf);
                    if (decoded == '\uffff') {
                        this.myOutBuffer.append("\\u");
                        this.myOutBuffer.append((char)buf[0]);
                        this.myOutBuffer.append((char)buf[1]);
                        this.myOutBuffer.append((char)buf[2]);
                        this.myOutBuffer.append((char)buf[3]);
                    } else {
                        this.myOutBuffer.append(decoded);
                    }
                } else {
                    this.myOutBuffer.append("\\");
                    this.myOutBuffer.append((char)next);
                }
                start = in.position();
            }
            this.decodeArray(in.array(), start, in.position());
        }
        catch (BufferUnderflowException e) {
            in.reset();
        }
        return this.doFlush(out);
    }

    private void decodeArray(byte[] buf, int start, int end) {
        if (end <= start) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf, start, end - start);
        CharBuffer charBuffer = this.myBaseCharset.decode(byteBuffer);
        this.myOutBuffer.append(charBuffer.toString());
    }

    private static char unicode(byte[] ord) {
        int d1 = Character.digit((char)ord[0], 16);
        if (d1 == -1) {
            return '\uffff';
        }
        int d2 = Character.digit((char)ord[1], 16);
        if (d2 == -1) {
            return '\uffff';
        }
        int d3 = Character.digit((char)ord[2], 16);
        if (d3 == -1) {
            return '\uffff';
        }
        int d4 = Character.digit((char)ord[3], 16);
        if (d4 == -1) {
            return '\uffff';
        }
        int b1 = d1 << 12 & 0xF000;
        int b2 = d2 << 8 & 0xF00;
        int b3 = d3 << 4 & 0xF0;
        int b4 = d4 << 0 & 0xF;
        int code = b1 | b2 | b3 | b4;
        if (Character.isWhitespace((char)code)) {
            return '\uffff';
        }
        return (char)code;
    }
}

