/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.lang.properties.charset;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.jet.internal.com.intellij.lang.properties.charset.Native2AsciiCharsetDecoder;
import org.jetbrains.jet.internal.com.intellij.lang.properties.charset.Native2AsciiCharsetEncoder;

public class Native2AsciiCharset
extends Charset {
    private final Charset myBaseCharset;

    private Native2AsciiCharset(String canonicalName) {
        super(canonicalName, null);
        String baseCharsetName = canonicalName.substring("NATIVE_TO_ASCII_".length());
        Charset baseCharset = null;
        try {
            baseCharset = Charset.forName(baseCharsetName);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        this.myBaseCharset = baseCharset == null ? Charset.forName("ISO-8859-1") : baseCharset;
    }

    @Override
    public String displayName() {
        return this.getBaseCharset().displayName();
    }

    @Override
    public boolean contains(Charset cs) {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Native2AsciiCharsetDecoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Native2AsciiCharsetEncoder(this);
    }

    public Charset getBaseCharset() {
        return this.myBaseCharset;
    }

    public static String makeNative2AsciiEncodingName(String baseCharsetName) {
        if (baseCharsetName == null) {
            baseCharsetName = "ISO-8859-1";
        }
        return "NATIVE_TO_ASCII_" + baseCharsetName;
    }

    public static Charset forName(String charsetName) {
        if (charsetName.startsWith("NATIVE_TO_ASCII_")) {
            return new Native2AsciiCharset(charsetName);
        }
        return null;
    }

    public static Charset wrap(Charset baseCharset) {
        return new Native2AsciiCharset("NATIVE_TO_ASCII_" + baseCharset.name());
    }

    public static Charset nativeToBaseCharset(Charset charset) {
        if (charset instanceof Native2AsciiCharset) {
            return ((Native2AsciiCharset)charset).getBaseCharset();
        }
        return charset;
    }
}

