/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.lang.java.parser;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.AbstractBundle;
import org.jetbrains.jet.internal.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilder;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.DeclarationParser;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.JavaParsers;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.ReferenceParser;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;

public class FileParser {
    public static final FileParser INSTANCE = new FileParser();
    private final ReferenceParser myReferenceParser;
    private final DeclarationParser myDeclarationParser;
    private static final TokenSet IMPORT_LIST_STOPPER_SET = TokenSet.orSet(ElementType.MODIFIER_BIT_SET, TokenSet.create(JavaTokenType.CLASS_KEYWORD, JavaTokenType.INTERFACE_KEYWORD, JavaTokenType.ENUM_KEYWORD, JavaTokenType.AT));

    private FileParser() {
        this(JavaParsers.DECLARATION_PARSER, JavaParsers.REFERENCE_PARSER);
    }

    protected FileParser(DeclarationParser declarationParser, ReferenceParser referenceParser) {
        this.myDeclarationParser = declarationParser;
        this.myReferenceParser = referenceParser;
    }

    public void parse(PsiBuilder builder) {
        this.parseFile(builder, IMPORT_LIST_STOPPER_SET, JavaErrorMessages.INSTANCE, "expected.class.or.interface");
    }

    private static String error(@NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/FileParser.error must not be null");
        }
        if (errorMessageKey == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/java/parser/FileParser.error must not be null");
        }
        return bundle.getMessage(errorMessageKey, new Object[0]);
    }

    public void parseFile(@NotNull PsiBuilder builder, @NotNull TokenSet importListStoppers, @NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/FileParser.parseFile must not be null");
        }
        if (importListStoppers == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/java/parser/FileParser.parseFile must not be null");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/java/parser/FileParser.parseFile must not be null");
        }
        if (errorMessageKey == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/java/parser/FileParser.parseFile must not be null");
        }
        this.parsePackageStatement(builder);
        Pair<PsiBuilder.Marker, Boolean> impListInfo = this.parseImportList(builder, importListStoppers);
        Boolean firstDeclarationOk = null;
        PsiBuilder.Marker firstDeclaration = null;
        PsiBuilder.Marker invalidElements = null;
        while (!builder.eof()) {
            if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(FileParser.error(bundle, errorMessageKey));
                    invalidElements = null;
                }
                builder.advanceLexer();
                if (firstDeclarationOk != null) continue;
                firstDeclarationOk = false;
                continue;
            }
            PsiBuilder.Marker declaration = this.parseInitial(builder);
            if (declaration != null) {
                if (invalidElements != null) {
                    invalidElements.errorBefore(FileParser.error(bundle, errorMessageKey), declaration);
                    invalidElements = null;
                }
                if (firstDeclarationOk != null || !(firstDeclarationOk = Boolean.valueOf(JavaParserUtil.exprType(declaration) != JavaElementType.MODIFIER_LIST)).booleanValue()) continue;
                firstDeclaration = declaration;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
            if (firstDeclarationOk != null) continue;
            firstDeclarationOk = false;
        }
        if (invalidElements != null) {
            invalidElements.error(FileParser.error(bundle, errorMessageKey));
        }
        if (((Boolean)impListInfo.second).booleanValue() && firstDeclarationOk == Boolean.TRUE) {
            ((PsiBuilder.Marker)impListInfo.first).setCustomEdgeTokenBinders(JavaParserUtil.PRECEDING_COMMENT_BINDER, null);
            firstDeclaration.setCustomEdgeTokenBinders(JavaParserUtil.SPECIAL_PRECEDING_COMMENT_BINDER, null);
        }
    }

    @Nullable
    protected PsiBuilder.Marker parseInitial(PsiBuilder builder) {
        return this.myDeclarationParser.parse(builder, DeclarationParser.Context.FILE);
    }

    @Nullable
    public PsiBuilder.Marker parsePackageStatement(PsiBuilder builder) {
        PsiBuilder.Marker ref;
        PsiBuilder.Marker statement = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.PACKAGE_KEYWORD)) {
            PsiBuilder.Marker modList = builder.mark();
            this.myDeclarationParser.parseAnnotations(builder);
            JavaParserUtil.done(modList, JavaElementType.MODIFIER_LIST);
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.PACKAGE_KEYWORD)) {
                statement.rollbackTo();
                return null;
            }
        }
        if ((ref = this.myReferenceParser.parseJavaCodeReference(builder, true, false, false, false, false)) == null) {
            statement.rollbackTo();
            return null;
        }
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.PACKAGE_STATEMENT);
        return statement;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseImportList(PsiBuilder builder, TokenSet stoppers) {
        boolean isEmpty;
        PsiBuilder.Marker list = builder.mark();
        boolean bl = isEmpty = builder.getTokenType() != JavaTokenType.IMPORT_KEYWORD;
        if (!isEmpty) {
            PsiBuilder.Marker invalidElements = null;
            while (!builder.eof() && !stoppers.contains(builder.getTokenType())) {
                PsiBuilder.Marker statement = this.parseImportStatement(builder);
                if (statement != null) {
                    if (invalidElements == null) continue;
                    invalidElements.errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), statement);
                    invalidElements = null;
                    continue;
                }
                if (invalidElements == null) {
                    invalidElements = builder.mark();
                }
                builder.advanceLexer();
            }
            if (invalidElements != null) {
                invalidElements.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
            }
        }
        JavaParserUtil.done(list, JavaElementType.IMPORT_LIST);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(list, isEmpty);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/FileParser.parseImportList must not return null");
        }
        return pair;
    }

    @Nullable
    private PsiBuilder.Marker parseImportStatement(PsiBuilder builder) {
        if (builder.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
            return null;
        }
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        boolean isStatic = PsiBuilderUtil.expect(builder, JavaTokenType.STATIC_KEYWORD);
        IElementType type = isStatic ? JavaElementType.IMPORT_STATIC_STATEMENT : JavaElementType.IMPORT_STATEMENT;
        boolean isOk = this.myReferenceParser.parseImportCodeReference(builder, isStatic);
        if (isOk) {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, type);
        return statement;
    }
}

