/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.lang.java.parser;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilder;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.DeclarationParser;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.ReferenceParser;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.TokenType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;

public class ExpressionParser {
    private final DeclarationParser myDeclarationParser;
    private final ReferenceParser myReferenceParser;
    private static final TokenSet ASSIGNMENT_OPS = TokenSet.create(JavaTokenType.EQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ, JavaTokenType.ANDEQ, JavaTokenType.OREQ, JavaTokenType.XOREQ);
    private static final TokenSet RELATIONAL_OPS = TokenSet.create(JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE);
    private static final TokenSet POSTFIX_OPS = TokenSet.create(JavaTokenType.PLUSPLUS, JavaTokenType.MINUSMINUS);
    private static final TokenSet PREF_ARITHMETIC_OPS = TokenSet.orSet(POSTFIX_OPS, TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS));
    private static final TokenSet PREFIX_OPS = TokenSet.orSet(PREF_ARITHMETIC_OPS, TokenSet.create(JavaTokenType.TILDE, JavaTokenType.EXCL));
    private static final TokenSet LITERALS = TokenSet.create(JavaTokenType.TRUE_KEYWORD, JavaTokenType.FALSE_KEYWORD, JavaTokenType.NULL_KEYWORD, JavaTokenType.INTEGER_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.STRING_LITERAL);
    private static final TokenSet CONDITIONAL_OR_OPS = TokenSet.create(JavaTokenType.OROR);
    private static final TokenSet CONDITIONAL_AND_OPS = TokenSet.create(JavaTokenType.ANDAND);
    private static final TokenSet OR_OPS = TokenSet.create(JavaTokenType.OR);
    private static final TokenSet XOR_OPS = TokenSet.create(JavaTokenType.XOR);
    private static final TokenSet AND_OPS = TokenSet.create(JavaTokenType.AND);
    private static final TokenSet EQUALITY_OPS = TokenSet.create(JavaTokenType.EQEQ, JavaTokenType.NE);
    private static final TokenSet SHIFT_OPS = TokenSet.create(JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT);
    private static final TokenSet ADDITIVE_OPS = TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS);
    private static final TokenSet MULTIPLICATIVE_OPS = TokenSet.create(JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);
    private static final TokenSet ARGS_LIST_END = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.RBRACE, JavaTokenType.RBRACKET);
    private static final TokenSet ARGS_LIST_CONTINUE = TokenSet.create(JavaTokenType.IDENTIFIER, TokenType.BAD_CHARACTER, JavaTokenType.COMMA, JavaTokenType.INTEGER_LITERAL, JavaTokenType.STRING_LITERAL);
    private static final TokenSet CONSTRUCTOR_CALL = TokenSet.create(JavaTokenType.THIS_KEYWORD, JavaTokenType.SUPER_KEYWORD);

    public ExpressionParser(DeclarationParser declarationParser, ReferenceParser referenceParser) {
        this.myDeclarationParser = declarationParser;
        this.myReferenceParser = referenceParser;
    }

    public ExpressionParser() {
        this(new DeclarationParser(), new ReferenceParser());
    }

    @Nullable
    public PsiBuilder.Marker parse(PsiBuilder builder) {
        return this.parseAssignment(builder);
    }

    @Nullable
    private PsiBuilder.Marker parseAssignment(PsiBuilder builder) {
        PsiBuilder.Marker left = this.parseConditional(builder);
        if (left == null) {
            return null;
        }
        IElementType tokenType = ExpressionParser.getGtTokenType(builder);
        if (ASSIGNMENT_OPS.contains(tokenType)) {
            PsiBuilder.Marker assignment = left.precede();
            ExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parse(builder);
            if (right == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            assignment.done(JavaElementType.ASSIGNMENT_EXPRESSION);
            return assignment;
        }
        return left;
    }

    @Nullable
    public PsiBuilder.Marker parseConditional(PsiBuilder builder) {
        PsiBuilder.Marker condition = this.parseExpression(builder, ExprType.CONDITIONAL_OR);
        if (condition == null) {
            return null;
        }
        if (builder.getTokenType() != JavaTokenType.QUEST) {
            return condition;
        }
        PsiBuilder.Marker ternary = condition.precede();
        builder.advanceLexer();
        PsiBuilder.Marker truePart = this.parse(builder);
        if (truePart == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        if (builder.getTokenType() != JavaTokenType.COLON) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.colon", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        builder.advanceLexer();
        PsiBuilder.Marker falsePart = this.parseConditional(builder);
        if (falsePart == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
        return ternary;
    }

    @Nullable
    private PsiBuilder.Marker parseExpression(PsiBuilder builder, ExprType type) {
        switch (type) {
            case CONDITIONAL_OR: {
                return this.parseBinary(builder, ExprType.CONDITIONAL_AND, CONDITIONAL_OR_OPS);
            }
            case CONDITIONAL_AND: {
                return this.parseBinary(builder, ExprType.OR, CONDITIONAL_AND_OPS);
            }
            case OR: {
                return this.parseBinary(builder, ExprType.XOR, OR_OPS);
            }
            case XOR: {
                return this.parseBinary(builder, ExprType.AND, XOR_OPS);
            }
            case AND: {
                return this.parseBinary(builder, ExprType.EQUALITY, AND_OPS);
            }
            case EQUALITY: {
                return this.parseBinary(builder, ExprType.RELATIONAL, EQUALITY_OPS);
            }
            case RELATIONAL: {
                return this.parseRelational(builder);
            }
            case SHIFT: {
                return this.parseBinary(builder, ExprType.ADDITIVE, SHIFT_OPS);
            }
            case ADDITIVE: {
                return this.parseBinary(builder, ExprType.MULTIPLICATIVE, ADDITIVE_OPS);
            }
            case MULTIPLICATIVE: {
                return this.parseBinary(builder, ExprType.UNARY, MULTIPLICATIVE_OPS);
            }
            case UNARY: {
                return this.parseUnary(builder);
            }
            case TYPE: {
                return this.myReferenceParser.parseType(builder, 5);
            }
        }
        assert (false) : "Unexpected type: " + (Object)((Object)type);
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parseBinary(PsiBuilder builder, ExprType type, TokenSet ops) {
        IElementType tokenType;
        PsiBuilder.Marker result = this.parseExpression(builder, type);
        if (result == null) {
            return null;
        }
        int operandCount = 1;
        IElementType currentExprTokenType = tokenType = ExpressionParser.getGtTokenType(builder);
        while (tokenType != null && ops.contains(tokenType)) {
            ExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parseExpression(builder, type);
            ++operandCount;
            tokenType = ExpressionParser.getGtTokenType(builder);
            if (tokenType != null && ops.contains(tokenType) && tokenType == currentExprTokenType && right != null) continue;
            result = result.precede();
            if (right == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            result.done(operandCount > 2 ? JavaElementType.POLYADIC_EXPRESSION : JavaElementType.BINARY_EXPRESSION);
            if (right == null) break;
            currentExprTokenType = tokenType;
            operandCount = 1;
        }
        return result;
    }

    @Nullable
    private PsiBuilder.Marker parseRelational(PsiBuilder builder) {
        PsiBuilder.Marker left = this.parseExpression(builder, ExprType.SHIFT);
        if (left == null) {
            return null;
        }
        while (true) {
            ExprType toParse;
            IElementType toCreate;
            IElementType tokenType;
            if (RELATIONAL_OPS.contains(tokenType = ExpressionParser.getGtTokenType(builder))) {
                toCreate = JavaElementType.BINARY_EXPRESSION;
                toParse = ExprType.SHIFT;
            } else {
                if (tokenType != JavaTokenType.INSTANCEOF_KEYWORD) break;
                toCreate = JavaElementType.INSTANCE_OF_EXPRESSION;
                toParse = ExprType.TYPE;
            }
            PsiBuilder.Marker expression = left.precede();
            ExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parseExpression(builder, toParse);
            if (right == null) {
                JavaParserUtil.error(builder, toParse == ExprType.TYPE ? JavaErrorMessages.message("expected.type", new Object[0]) : JavaErrorMessages.message("expected.expression", new Object[0]));
                expression.done(toCreate);
                return expression;
            }
            expression.done(toCreate);
            left = expression;
        }
        return left;
    }

    @Nullable
    private PsiBuilder.Marker parseUnary(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (PREFIX_OPS.contains(tokenType)) {
            PsiBuilder.Marker unary = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker operand = this.parseUnary(builder);
            if (operand == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            unary.done(JavaElementType.PREFIX_EXPRESSION);
            return unary;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker typeCast = builder.mark();
            builder.advanceLexer();
            ReferenceParser.TypeInfo typeInfo = this.myReferenceParser.parseTypeInfo(builder, 5);
            if (typeInfo == null || builder.getTokenType() != JavaTokenType.RPARENTH) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder);
            }
            builder.advanceLexer();
            if (PREF_ARITHMETIC_OPS.contains(builder.getTokenType()) && !typeInfo.isPrimitive) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder);
            }
            PsiBuilder.Marker expr = this.parseUnary(builder);
            if (expr == null) {
                if (!typeInfo.isParameterized) {
                    typeCast.rollbackTo();
                    return this.parsePostfix(builder);
                }
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            typeCast.done(JavaElementType.TYPE_CAST_EXPRESSION);
            return typeCast;
        }
        return this.parsePostfix(builder);
    }

    @Nullable
    private PsiBuilder.Marker parsePostfix(PsiBuilder builder) {
        PsiBuilder.Marker operand = this.parsePrimary(builder, null, -1);
        if (operand == null) {
            return null;
        }
        while (POSTFIX_OPS.contains(builder.getTokenType())) {
            PsiBuilder.Marker postfix = operand.precede();
            builder.advanceLexer();
            postfix.done(JavaElementType.POSTFIX_EXPRESSION);
            operand = postfix;
        }
        return operand;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimary(PsiBuilder builder, @Nullable BreakPoint breakPoint, int breakOffset) {
        PsiBuilder.Marker startMarker = builder.mark();
        PsiBuilder.Marker expr = this.parsePrimaryExpressionStart(builder);
        if (expr == null) {
            startMarker.drop();
            return null;
        }
        while (true) {
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == JavaTokenType.DOT) {
                PsiBuilder.Marker refExpr;
                int offset;
                PsiBuilder.Marker copy;
                PsiBuilder.Marker dotPos = builder.mark();
                int dotOffset = builder.getCurrentOffset();
                builder.advanceLexer();
                IElementType dotTokenType = builder.getTokenType();
                if (dotTokenType == JavaTokenType.CLASS_KEYWORD && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P1 && builder.getCurrentOffset() == breakOffset) {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                        PsiBuilderUtil.drop(startMarker, dotPos);
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker classObjAccess = this.parseClassObjectAccess(builder);
                    if (classObjAccess == null || builder.getCurrentOffset() < offset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P1, offset);
                    }
                    startMarker = copy;
                    expr = classObjAccess;
                    continue;
                }
                if (dotTokenType == JavaTokenType.NEW_KEYWORD) {
                    dotPos.drop();
                    expr = this.parseNew(builder, expr);
                    continue;
                }
                if ((dotTokenType == JavaTokenType.THIS_KEYWORD || dotTokenType == JavaTokenType.SUPER_KEYWORD) && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P2 && builder.getCurrentOffset() == breakOffset) {
                        dotPos.rollbackTo();
                        startMarker.drop();
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker ref = this.myReferenceParser.parseJavaCodeReference(builder, false, true, false, false, false);
                    if (ref == null || builder.getTokenType() != JavaTokenType.DOT || builder.getCurrentOffset() != dotOffset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset);
                    }
                    builder.advanceLexer();
                    if (builder.getTokenType() != dotTokenType) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset);
                    }
                    builder.advanceLexer();
                    startMarker = copy;
                    expr = ref.precede();
                    expr.done(dotTokenType == JavaTokenType.THIS_KEYWORD ? JavaElementType.THIS_EXPRESSION : JavaElementType.SUPER_EXPRESSION);
                    continue;
                }
                if (dotTokenType == JavaTokenType.SUPER_KEYWORD) {
                    dotPos.drop();
                    refExpr = expr.precede();
                    builder.advanceLexer();
                    refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                    expr = refExpr;
                    continue;
                }
                dotPos.drop();
                refExpr = expr.precede();
                this.myReferenceParser.parseReferenceParameterList(builder, false, false);
                if (!JavaParserUtil.expectOrError(builder, JavaTokenType.IDENTIFIER, "expected.identifier")) {
                    refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                    startMarker.drop();
                    return refExpr;
                }
                refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                expr = refExpr;
                continue;
            }
            if (tokenType == JavaTokenType.LPARENTH) {
                if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                    if (JavaParserUtil.exprType(expr) == JavaElementType.SUPER_EXPRESSION) {
                        if (breakPoint == BreakPoint.P3) {
                            startMarker.drop();
                            return expr;
                        }
                        PsiBuilder.Marker copy = startMarker.precede();
                        startMarker.rollbackTo();
                        PsiBuilder.Marker qualifier = this.parsePrimaryExpressionStart(builder);
                        if (qualifier != null) {
                            PsiBuilder.Marker refExpr = qualifier.precede();
                            if (builder.getTokenType() == JavaTokenType.DOT) {
                                builder.advanceLexer();
                                if (builder.getTokenType() == JavaTokenType.SUPER_KEYWORD) {
                                    builder.advanceLexer();
                                    refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                                    expr = refExpr;
                                    startMarker = copy;
                                    continue;
                                }
                            }
                        }
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P3, -1);
                    }
                    startMarker.drop();
                    return expr;
                }
                PsiBuilder.Marker callExpr = expr.precede();
                this.parseArgumentList(builder);
                callExpr.done(JavaElementType.METHOD_CALL_EXPRESSION);
                expr = callExpr;
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) break;
            if (breakPoint == BreakPoint.P4) {
                startMarker.drop();
                return expr;
            }
            builder.advanceLexer();
            if (builder.getTokenType() == JavaTokenType.RBRACKET && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                int pos = builder.getCurrentOffset();
                PsiBuilder.Marker copy = startMarker.precede();
                startMarker.rollbackTo();
                PsiBuilder.Marker classObjAccess = this.parseClassObjectAccess(builder);
                if (classObjAccess == null || builder.getCurrentOffset() <= pos) {
                    copy.rollbackTo();
                    return this.parsePrimary(builder, BreakPoint.P4, -1);
                }
                startMarker = copy;
                expr = classObjAccess;
                continue;
            }
            PsiBuilder.Marker arrayAccess = expr.precede();
            PsiBuilder.Marker index = this.parse(builder);
            if (index == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
                arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            if (builder.getTokenType() != JavaTokenType.RBRACKET) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbracket", new Object[0]));
                arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            builder.advanceLexer();
            arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
            expr = arrayAccess;
        }
        startMarker.drop();
        return expr;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimaryExpressionStart(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (LITERALS.contains(tokenType)) {
            PsiBuilder.Marker literal = builder.mark();
            builder.advanceLexer();
            literal.done(JavaElementType.LITERAL_EXPRESSION);
            return literal;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker parenth = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker inner = this.parse(builder);
            if (inner == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH) && inner != null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
            }
            parenth.done(JavaElementType.PARENTH_EXPRESSION);
            return parenth;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseArrayInitializer(builder);
        }
        PsiBuilder.Marker annotation = null;
        PsiBuilder.Marker beforeAnnotation = builder.mark();
        if (tokenType == JavaTokenType.AT) {
            annotation = this.myDeclarationParser.parseAnnotations(builder);
            tokenType = builder.getTokenType();
        }
        if (tokenType == JavaTokenType.IDENTIFIER) {
            PsiBuilder.Marker refExpr;
            if (annotation != null) {
                PsiBuilder.Marker refParam = annotation.precede();
                refParam.doneBefore(JavaElementType.REFERENCE_PARAMETER_LIST, annotation);
                refExpr = refParam.precede();
            } else {
                refExpr = builder.mark();
                builder.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
            beforeAnnotation.drop();
            return refExpr;
        }
        if (annotation != null) {
            beforeAnnotation.rollbackTo();
            tokenType = builder.getTokenType();
        } else {
            beforeAnnotation.drop();
        }
        PsiBuilder.Marker expr = null;
        if (tokenType == JavaTokenType.LT) {
            expr = builder.mark();
            if (!this.myReferenceParser.parseReferenceParameterList(builder, false, false)) {
                expr.rollbackTo();
                return null;
            }
            tokenType = builder.getTokenType();
            if (!CONSTRUCTOR_CALL.contains(tokenType)) {
                expr.rollbackTo();
                return null;
            }
        }
        if (CONSTRUCTOR_CALL.contains(tokenType)) {
            if (expr == null) {
                expr = builder.mark();
                builder.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            expr.done(builder.getTokenType() == JavaTokenType.LPARENTH ? JavaElementType.REFERENCE_EXPRESSION : (tokenType == JavaTokenType.THIS_KEYWORD ? JavaElementType.THIS_EXPRESSION : JavaElementType.SUPER_EXPRESSION));
            return expr;
        }
        if (tokenType == JavaTokenType.NEW_KEYWORD) {
            return this.parseNew(builder, null);
        }
        if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
            return this.parseClassObjectAccess(builder);
        }
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parseArrayInitializer(PsiBuilder builder) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker arrayInit = builder.mark();
        builder.advanceLexer();
        boolean expressionMissed = false;
        PsiBuilder.Marker lastComma = null;
        while (true) {
            IElementType tokenType;
            PsiBuilder.Marker arg;
            if (builder.getTokenType() == JavaTokenType.RBRACE) {
                builder.advanceLexer();
                break;
            }
            if (builder.getTokenType() == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbrace", new Object[0]));
                break;
            }
            if (expressionMissed && lastComma != null) {
                lastComma.precede().errorBefore(JavaErrorMessages.message("expected.expression", new Object[0]), lastComma);
                lastComma.drop();
                lastComma = null;
            }
            if ((arg = this.parse(builder)) == null) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    expressionMissed = true;
                    lastComma = builder.mark();
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbrace", new Object[0]));
                    break;
                }
            }
            if ((tokenType = builder.getTokenType()) == JavaTokenType.COMMA) {
                builder.advanceLexer();
                continue;
            }
            if (tokenType == JavaTokenType.RBRACE) continue;
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma", new Object[0]));
        }
        if (lastComma != null) {
            lastComma.drop();
        }
        arrayInit.done(JavaElementType.ARRAY_INITIALIZER_EXPRESSION);
        return arrayInit;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private PsiBuilder.Marker parseNew(PsiBuilder builder, @Nullable PsiBuilder.Marker start) {
        PsiBuilder.Marker marker;
        PsiBuilder.Marker newExpr;
        block20: {
            PsiBuilder.Marker refOrType;
            newExpr = start != null ? start.precede() : builder.mark();
            builder.advanceLexer();
            boolean parseDiamonds = JavaParserUtil.areDiamondsSupported(builder);
            this.myReferenceParser.parseReferenceParameterList(builder, false, parseDiamonds);
            boolean parseAnnotations = JavaParserUtil.areTypeAnnotationsSupported(builder) && builder.getTokenType() == JavaTokenType.AT;
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER || parseAnnotations) {
                refOrType = this.myReferenceParser.parseJavaCodeReference(builder, true, true, parseAnnotations, true, parseDiamonds);
                if (refOrType == null) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    newExpr.done(JavaElementType.NEW_EXPRESSION);
                    marker = newExpr;
                    if (marker == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ExpressionParser.parseNew must not return null");
                    return marker;
                }
            } else {
                if (!ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    newExpr.done(JavaElementType.NEW_EXPRESSION);
                    marker = newExpr;
                    if (marker == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ExpressionParser.parseNew must not return null");
                    return marker;
                }
                refOrType = null;
                builder.advanceLexer();
            }
            if (refOrType != null && builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.parseArgumentList(builder);
                if (builder.getTokenType() == JavaTokenType.LBRACE) {
                    PsiBuilder.Marker classElement = refOrType.precede();
                    this.myDeclarationParser.parseClassBodyWithBraces(builder, false, false);
                    classElement.done(JavaElementType.ANONYMOUS_CLASS);
                }
            } else {
                block21: {
                    if (builder.getTokenType() != JavaTokenType.LBRACKET) {
                        JavaParserUtil.error(builder, refOrType == null ? JavaErrorMessages.message("expected.lbracket", new Object[0]) : JavaErrorMessages.message("expected.lparen.or.lbracket", new Object[0]));
                        newExpr.done(JavaElementType.NEW_EXPRESSION);
                        marker = newExpr;
                        if (marker == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ExpressionParser.parseNew must not return null");
                        return marker;
                    }
                    int bracketCount = 0;
                    int dimCount = 0;
                    do {
                        PsiBuilder.Marker dimExpr;
                        if (builder.getTokenType() != JavaTokenType.LBRACKET) {
                            if (dimCount != 0) break block20;
                            break block21;
                        }
                        builder.advanceLexer();
                        if (bracketCount == dimCount && (dimExpr = this.parse(builder)) != null) {
                            ++dimCount;
                        }
                        ++bracketCount;
                    } while (JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACKET, "expected.rbracket"));
                    newExpr.done(JavaElementType.NEW_EXPRESSION);
                    marker = newExpr;
                    if (marker == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ExpressionParser.parseNew must not return null");
                    return marker;
                }
                if (builder.getTokenType() == JavaTokenType.LBRACE) {
                    this.parseArrayInitializer(builder);
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.array.initializer", new Object[0]));
                }
            }
        }
        newExpr.done(JavaElementType.NEW_EXPRESSION);
        marker = newExpr;
        if (marker != null) return marker;
        throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ExpressionParser.parseNew must not return null");
    }

    @Nullable
    private PsiBuilder.Marker parseClassObjectAccess(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (this.myReferenceParser.parseType(builder, 0) == null) {
            expr.drop();
            return null;
        }
        if (builder.getTokenType() != JavaTokenType.DOT) {
            expr.rollbackTo();
            return null;
        }
        PsiBuilder.Marker afterType = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == JavaTokenType.CLASS_KEYWORD) {
            afterType.drop();
            builder.advanceLexer();
        } else {
            afterType.rollbackTo();
            builder.error(".class expected");
        }
        expr.done(JavaElementType.CLASS_OBJECT_ACCESS_EXPRESSION);
        return expr;
    }

    @NotNull
    public PsiBuilder.Marker parseArgumentList(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        builder.advanceLexer();
        boolean first = true;
        while (true) {
            IElementType tokenType = builder.getTokenType();
            if (first && (ARGS_LIST_END.contains(tokenType) || builder.eof()) || !first && !ARGS_LIST_CONTINUE.contains(tokenType)) break;
            boolean hasError = false;
            if (!first) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    builder.advanceLexer();
                } else {
                    hasError = true;
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma.or.rparen", new Object[0]));
                    ExpressionParser.emptyExpression(builder);
                }
            }
            first = false;
            PsiBuilder.Marker arg = this.parse(builder);
            if (arg != null) continue;
            if (!hasError) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
                ExpressionParser.emptyExpression(builder);
            }
            if (!ARGS_LIST_CONTINUE.contains(builder.getTokenType())) break;
            if (builder.getTokenType() == JavaTokenType.COMMA || builder.eof()) continue;
            builder.advanceLexer();
        }
        boolean closed = JavaParserUtil.expectOrError(builder, JavaTokenType.RPARENTH, "expected.rparen");
        list.done(JavaElementType.EXPRESSION_LIST);
        if (!closed) {
            list.setCustomEdgeTokenBinders(null, JavaParserUtil.GREEDY_RIGHT_EDGE_PROCESSOR);
        }
        PsiBuilder.Marker marker = list;
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ExpressionParser.parseArgumentList must not return null");
        }
        return marker;
    }

    private static void emptyExpression(PsiBuilder builder) {
        JavaParserUtil.emptyElement(builder, JavaElementType.EMPTY_EXPRESSION);
    }

    @Nullable
    private static IElementType getGtTokenType(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.GT) {
            return tokenType;
        }
        if (builder.rawLookup(1) == JavaTokenType.GT) {
            tokenType = builder.rawLookup(2) == JavaTokenType.GT ? (builder.rawLookup(3) == JavaTokenType.EQ ? JavaTokenType.GTGTGTEQ : JavaTokenType.GTGTGT) : (builder.rawLookup(2) == JavaTokenType.EQ ? JavaTokenType.GTGTEQ : JavaTokenType.GTGT);
        } else if (builder.rawLookup(1) == JavaTokenType.EQ) {
            tokenType = JavaTokenType.GE;
        }
        return tokenType;
    }

    private static void advanceGtToken(PsiBuilder builder, IElementType type) {
        PsiBuilder.Marker gtToken = builder.mark();
        if (type == JavaTokenType.GTGTGTEQ) {
            PsiBuilderUtil.advance(builder, 4);
        } else if (type == JavaTokenType.GTGTGT || type == JavaTokenType.GTGTEQ) {
            PsiBuilderUtil.advance(builder, 3);
        } else if (type == JavaTokenType.GTGT || type == JavaTokenType.GE) {
            PsiBuilderUtil.advance(builder, 2);
        } else {
            gtToken.drop();
            builder.advanceLexer();
            return;
        }
        gtToken.collapse(type);
    }

    private static enum BreakPoint {
        P1,
        P2,
        P3,
        P4;

    }

    private static enum ExprType {
        CONDITIONAL_OR,
        CONDITIONAL_AND,
        OR,
        XOR,
        AND,
        EQUALITY,
        RELATIONAL,
        SHIFT,
        ADDITIVE,
        MULTIPLICATIVE,
        UNARY,
        TYPE;

    }
}

