/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.lang.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageUtil;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.lang.PsiParser;
import org.jetbrains.jet.internal.com.intellij.lexer.JavaLexer;
import org.jetbrains.jet.internal.com.intellij.lexer.Lexer;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.JavaDocTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiJavaFileImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;

public class JavaParserDefinition
implements ParserDefinition {
    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance(project).getLanguageLevel();
        Lexer lexer = JavaParserDefinition.createLexer(languageLevel);
        if (lexer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createLexer must not return null");
        }
        return lexer;
    }

    @NotNull
    public static Lexer createLexer(LanguageLevel languageLevel) {
        JavaLexer javaLexer = new JavaLexer(languageLevel);
        if (javaLexer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createLexer must not return null");
        }
        return javaLexer;
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JavaStubElementTypes.JAVA_FILE;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = ElementType.JAVA_WHITESPACE_BIT_SET;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.getWhitespaceTokens must not return null");
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = ElementType.JAVA_COMMENT_BIT_SET;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.getCommentTokens must not return null");
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create(JavaElementType.LITERAL_EXPRESSION);
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.getStringLiteralElements must not return null");
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof JavaStubElementType) {
            Object PsiT = ((JavaStubElementType)type).createPsi(node);
            if (PsiT == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createElement must not return null");
            }
            return PsiT;
        }
        throw new IllegalStateException("Incorrect node for JavaParserDefinition: " + node + " (" + type + ")");
    }

    @Override
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PsiJavaFileImpl(viewProvider);
    }

    @Override
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        String text;
        PsiFile containingFile = left.getTreeParent().getPsi().getContainingFile();
        JavaLexer lexer = containingFile instanceof PsiJavaFile ? new JavaLexer(((PsiJavaFile)containingFile).getLanguageLevel()) : new JavaLexer(LanguageLevel.HIGHEST);
        if (right.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer(left, right, lexer);
        if (left.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && (text = left.getText()).length() > 0 && Character.isWhitespace(text.charAt(text.length() - 1))) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (right.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA ? (text = right.getText()).length() > 0 && Character.isWhitespace(text.charAt(0)) : right.getElementType() == JavaDocTokenType.DOC_INLINE_TAG_END) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        return spaceRequirements;
    }
}

