/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.lang;

import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageExtension;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.lang.TokenSeparatorGenerator;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.TokenType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtilCore;

public class LanguageTokenSeparatorGenerators
extends LanguageExtension<TokenSeparatorGenerator> {
    public static final LanguageTokenSeparatorGenerators INSTANCE = new LanguageTokenSeparatorGenerators();

    private LanguageTokenSeparatorGenerators() {
        super("org.jetbrains.jet.internal.com.intellij.lang.tokenSeparatorGenerator", new TokenSeparatorGenerator(){

            @Override
            public ASTNode generateWhitespaceBetweenTokens(ASTNode left, ASTNode right) {
                Language l = PsiUtilCore.getNotAnyLanguage(left);
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
                if (parserDefinition != null) {
                    LeafElement generatedWhitespace;
                    PsiManager manager = right.getTreeParent().getPsi().getManager();
                    switch (parserDefinition.spaceExistanceTypeBetweenTokens(left, right)) {
                        case MUST: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, null, manager);
                            break;
                        }
                        case MUST_LINE_BREAK: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager);
                            break;
                        }
                        default: {
                            generatedWhitespace = null;
                        }
                    }
                    return generatedWhitespace;
                }
                return null;
            }
        });
    }
}

