/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.lang;

import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.KeyedExtensionCollector;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE = new Key("EXTENSIONS_IN_LANGUAGE");

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
    }

    @Override
    protected String keyToString(Language key) {
        return key.getID();
    }

    @Nullable
    public T forLanguage(@NotNull Language l) {
        Language base;
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/LanguageExtension.forLanguage must not be null");
        }
        T cached = l.getUserData(this.IN_LANGUAGE_CACHE);
        if (cached != null) {
            return cached;
        }
        List extensions = this.forKey(l);
        Object result = extensions.isEmpty() ? ((base = l.getBaseLanguage()) == null ? this.myDefaultImplementation : this.forLanguage(base)) : extensions.get(0);
        if (result == null) {
            return result;
        }
        l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<T> allForLanguage(Language l) {
        List list;
        Language base;
        List list2 = this.forKey(l);
        if (list2.isEmpty() && (base = l.getBaseLanguage()) != null) {
            list = this.allForLanguage(base);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/LanguageExtension.allForLanguage must not return null");
            return list;
        }
        list = list2;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/LanguageExtension.allForLanguage must not return null");
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    protected Key<T> getLanguageCache() {
        return this.IN_LANGUAGE_CACHE;
    }
}

