/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.extapi.psi;

import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IFileElementType;

public abstract class PsiFileBase
extends PsiFileImpl {
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final ParserDefinition myParserDefinition;

    protected PsiFileBase(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        if (viewProvider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiFileBase.<init> must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/extapi/psi/PsiFileBase.<init> must not be null");
        }
        super(viewProvider);
        this.myLanguage = PsiFileBase.findLanguage(language, viewProvider);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myLanguage);
        if (parserDefinition == null) {
            throw new RuntimeException("PsiFileBase: language.getParserDefinition() returned null for: " + this.myLanguage);
        }
        this.myParserDefinition = parserDefinition;
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        assert (nodeType.getLanguage() == this.myLanguage) : nodeType.getLanguage() + " != " + this.myLanguage;
        this.init(nodeType, nodeType);
    }

    private static Language findLanguage(Language baseLanguage, FileViewProvider viewProvider) {
        Set<Language> languages = viewProvider.getLanguages();
        for (Language actualLanguage : languages) {
            if (!actualLanguage.isKindOf(baseLanguage)) continue;
            return actualLanguage;
        }
        throw new AssertionError((Object)("Language " + baseLanguage + " doesn't participate in view provider " + viewProvider + ": " + new ArrayList<Language>(languages)));
    }

    @Override
    @NotNull
    public final Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiFileBase.getLanguage must not return null");
        }
        return language;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiFileBase.accept must not be null");
        }
        visitor.visitFile(this);
    }

    @NotNull
    public ParserDefinition getParserDefinition() {
        ParserDefinition parserDefinition = this.myParserDefinition;
        if (parserDefinition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiFileBase.getParserDefinition must not return null");
        }
        return parserDefinition;
    }
}

