/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.extapi.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.jet.internal.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiElementBase;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public abstract class ASTDelegatePsiElement
extends PsiElementBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.extapi.psi.ASTDelegatePsiElement");
    private static final List EMPTY = Collections.emptyList();

    @Override
    public PsiManagerEx getManager() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return (PsiManagerEx)parent.getManager();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.getChildren must not return null");
            return psiElementArray;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            if (psiChild.getNode() instanceof CompositeElement) {
                result.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.getChildren must not return null");
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this.getNode());
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this.getNode());
    }

    @Override
    public TextRange getTextRange() {
        return this.getNode().getTextRange();
    }

    @Override
    public int getStartOffsetInParent() {
        return this.getNode().getStartOffset() - this.getNode().getTreeParent().getStartOffset();
    }

    @Override
    public int getTextLength() {
        return this.getNode().getTextLength();
    }

    @Override
    public PsiElement findElementAt(int offset) {
        ASTNode treeElement = this.getNode().findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(treeElement);
    }

    @Override
    public int getTextOffset() {
        return this.getNode().getStartOffset();
    }

    @Override
    public String getText() {
        return this.getNode().getText();
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.getNode().getText().toCharArray();
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.textToCharArray must not return null");
        }
        return cArray;
    }

    @Override
    public boolean textContains(char c) {
        return this.getNode().textContains(c);
    }

    @Override
    public <T> T getCopyableUserData(Key<T> key) {
        return this.getNode().getCopyableUserData(key);
    }

    @Override
    public <T> void putCopyableUserData(Key<T> key, T value) {
        this.getNode().putCopyableUserData(key, value);
    }

    @Override
    @NotNull
    public abstract ASTNode getNode();

    public void subtreeChanged() {
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getNode().getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.getLanguage must not return null");
        }
        return language;
    }

    @Nullable
    protected PsiElement findChildByType(IElementType type) {
        ASTNode node = this.getNode().findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    protected PsiElement findLastChildByType(IElementType type) {
        for (PsiElement child = this.getLastChild(); child != null; child = child.getPrevSibling()) {
            ASTNode node = child.getNode();
            if (node == null || node.getElementType() != type) continue;
            return child;
        }
        return null;
    }

    @NotNull
    protected PsiElement findNotNullChildByType(IElementType type) {
        PsiElement psiElement = this.notNullChild(this.findChildByType(type));
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.findNotNullChildByType must not return null");
        }
        return psiElement;
    }

    @Nullable
    protected PsiElement findChildByType(TokenSet type) {
        ASTNode node = this.getNode().findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    @NotNull
    protected PsiElement findNotNullChildByType(TokenSet type) {
        PsiElement psiElement = this.notNullChild(this.findChildByType(type));
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.findNotNullChildByType must not return null");
        }
        return psiElement;
    }

    @Nullable
    protected PsiElement findChildByFilter(TokenSet tokenSet) {
        ASTNode[] nodes = this.getNode().getChildren(tokenSet);
        return nodes == null || nodes.length == 0 ? null : nodes[0].getPsi();
    }

    @NotNull
    protected PsiElement findNotNullChildByFilter(TokenSet tokenSet) {
        PsiElement psiElement = this.notNullChild(this.findChildByFilter(tokenSet));
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.findNotNullChildByFilter must not return null");
        }
        return psiElement;
    }

    protected <T extends PsiElement> T[] findChildrenByType(IElementType elementType, Class<T> arrayClass) {
        return (PsiElement[])ContainerUtil.map2Array(SharedImplUtil.getChildrenOfType(this.getNode(), elementType), arrayClass, new Function<ASTNode, T>(){

            @Override
            public T fun(ASTNode s) {
                return s.getPsi();
            }
        });
    }

    protected <T extends PsiElement> List<T> findChildrenByType(TokenSet elementType) {
        ArrayList<PsiElement> result = EMPTY;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!elementType.contains(tt)) continue;
            if (result == EMPTY) {
                result = new ArrayList<PsiElement>();
            }
            result.add(child.getPsi());
        }
        return result;
    }

    protected <T extends PsiElement> List<T> findChildrenByType(IElementType elementType) {
        ArrayList<PsiElement> result = EMPTY;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (elementType != child.getElementType()) continue;
            if (result == EMPTY) {
                result = new ArrayList<PsiElement>();
            }
            result.add(child.getPsi());
        }
        return result;
    }

    protected <T extends PsiElement> T[] findChildrenByType(TokenSet elementType, Class<T> arrayClass) {
        return ContainerUtil.map2Array(this.getNode().getChildren(elementType), arrayClass, new Function<ASTNode, PsiElement>(){

            @Override
            public PsiElement fun(ASTNode s) {
                return s.getPsi();
            }
        });
    }

    @Override
    public PsiElement copy() {
        return this.getNode().copyElement().getPsi();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.add must not be null");
        }
        return this.addInnerBefore(element, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.addBefore must not be null");
        }
        return this.addInnerBefore(element, anchor);
    }

    private PsiElement addInnerBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        if (treeElement != null) {
            if (treeElement instanceof TreeElement) {
                return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
            }
            return treeElement.getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.addAfter must not be null");
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        if (treeElement instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
        }
        return treeElement.getPsi();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.checkAdd must not be null");
        }
        CheckUtil.checkWritable(this);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        return CodeEditUtil.addChildren(this.getNode(), first, last, this.getAnchorNode(anchor, before));
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.addRangeBefore must not be null");
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable(this);
            ((ASTDelegatePsiElement)parent).deleteChildInternal(this.getNode());
        } else if (parent instanceof CompositePsiElement) {
            CheckUtil.checkWritable(this);
            ((CompositePsiElement)parent).deleteChildInternal(this.getNode());
        } else if (parent instanceof PsiFile) {
            CheckUtil.checkWritable(this);
            parent.deleteChildRange(this, this);
        } else {
            throw new UnsupportedOperationException(this.getClass().getName() + " under " + (parent == null ? "null" : parent.getClass().getName()));
        }
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.deleteChildInternal must not be null");
        }
        CodeEditUtil.removeChild(this.getNode(), child);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this.getNode());
        LOG.assertTrue(lastElement.getTreeParent() == this.getNode());
        CodeEditUtil.removeChildren(this.getNode(), firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.replace must not be null");
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            ASTDelegatePsiElement parentElement = (ASTDelegatePsiElement)this.getParent();
            parentElement.replaceChildInternal(this, elementCopy);
        } else {
            CodeEditUtil.replaceChild(this.getParent().getNode(), this.getNode(), elementCopy);
        }
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public void replaceChildInternal(PsiElement child, TreeElement newElement) {
        CodeEditUtil.replaceChild(this.getNode(), child.getNode(), newElement);
    }

    private ASTNode getAnchorNode(ASTNode anchor, Boolean before) {
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before != null && before == false ? this.getNode().getFirstChildNode() : null);
        return anchorBefore;
    }
}

