/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.execution.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.execution.process.ProcessAdapter;
import org.jetbrains.jet.internal.com.intellij.execution.process.ProcessEvent;
import org.jetbrains.jet.internal.com.intellij.execution.process.ProcessHandler;
import org.jetbrains.jet.internal.com.intellij.execution.process.ProcessOutputTypes;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.util.Consumer;
import org.jetbrains.jet.internal.com.intellij.util.io.OutputReader;

public class BaseOSProcessHandler
extends ProcessHandler {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.process.OSProcessHandlerBase");
    @NotNull
    protected final Process myProcess;
    @Nullable
    protected final String myCommandLine;
    protected final ProcessWaitFor myWaitFor;
    @Nullable
    private final Charset myCharset;

    public BaseOSProcessHandler(@NotNull Process process, @Nullable String commandLine, @Nullable Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/process/BaseOSProcessHandler.<init> must not be null");
        }
        this.myProcess = process;
        this.myCommandLine = commandLine;
        this.myCharset = charset;
        this.myWaitFor = new ProcessWaitFor(process);
    }

    protected Future<?> executeOnPooledThread(Runnable task) {
        return ExecutorServiceHolder.ourThreadExecutorsService.submit(task);
    }

    @NotNull
    public Process getProcess() {
        Process process = this.myProcess;
        if (process == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/process/BaseOSProcessHandler.getProcess must not return null");
        }
        return process;
    }

    @Override
    public void startNotify() {
        if (this.myCommandLine != null) {
            this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        }
        this.addProcessListener(new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNotified(ProcessEvent event) {
                try {
                    final OutputReader stdoutReader = new OutputReader(BaseOSProcessHandler.this.createProcessOutReader()){

                        @Override
                        protected void onTextAvailable(@NotNull String text) {
                            if (text == null) {
                                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/process/BaseOSProcessHandler$1$1.onTextAvailable must not be null");
                            }
                            BaseOSProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDOUT);
                        }

                        @Override
                        protected Future<?> executeOnPooledThread(Runnable runnable) {
                            return BaseOSProcessHandler.this.executeOnPooledThread(runnable);
                        }
                    };
                    final OutputReader stderrReader = new OutputReader(BaseOSProcessHandler.this.createProcessErrReader()){

                        @Override
                        protected void onTextAvailable(@NotNull String text) {
                            if (text == null) {
                                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/process/BaseOSProcessHandler$1$2.onTextAvailable must not be null");
                            }
                            BaseOSProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDERR);
                        }

                        @Override
                        protected Future<?> executeOnPooledThread(Runnable runnable) {
                            return BaseOSProcessHandler.this.executeOnPooledThread(runnable);
                        }
                    };
                    BaseOSProcessHandler.this.myWaitFor.setTerminationCallback(new Consumer<Integer>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void consume(Integer exitCode) {
                            try {
                                stderrReader.stop();
                                stdoutReader.stop();
                                try {
                                    stderrReader.waitFor();
                                    stdoutReader.waitFor();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            finally {
                                BaseOSProcessHandler.this.onOSProcessTerminated(exitCode);
                            }
                        }
                    });
                }
                finally {
                    BaseOSProcessHandler.this.removeProcessListener(this);
                }
            }
        });
        super.startNotify();
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    protected Reader createProcessOutReader() {
        return this.createInputStreamReader(this.myProcess.getInputStream());
    }

    protected Reader createProcessErrReader() {
        return this.createInputStreamReader(this.myProcess.getErrorStream());
    }

    private Reader createInputStreamReader(InputStream streamToRead) {
        Charset charset = this.getCharset();
        if (charset == null) {
            return new InputStreamReader(streamToRead);
        }
        return new InputStreamReader(streamToRead, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void doDestroyProcess() {
        this.getProcess().destroy();
    }

    @Override
    protected void detachProcessImpl() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseOSProcessHandler.this.closeStreams();
                BaseOSProcessHandler.this.myWaitFor.detach();
                BaseOSProcessHandler.this.notifyProcessDetached();
            }
        };
        this.executeOnPooledThread(runnable);
    }

    protected void closeStreams() {
        try {
            this.myProcess.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Override
    public boolean detachIsDefault() {
        return false;
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcess.getOutputStream();
    }

    @Nullable
    public String getCommandLine() {
        return this.myCommandLine;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    protected class ProcessWaitFor {
        private final Future<?> myWaitForThreadFuture;
        private final BlockingQueue<Consumer<Integer>> myTerminationCallback = new ArrayBlockingQueue<Consumer<Integer>>(1);

        public void detach() {
            this.myWaitForThreadFuture.cancel(true);
        }

        public ProcessWaitFor(final Process process) {
            this.myWaitForThreadFuture = BaseOSProcessHandler.this.executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int exitCode = 0;
                    try {
                        while (true) {
                            try {
                                exitCode = process.waitFor();
                            }
                            catch (InterruptedException e) {
                                LOG.debug(e);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        try {
                            ((Consumer)ProcessWaitFor.this.myTerminationCallback.take()).consume(exitCode);
                        }
                        catch (InterruptedException e) {
                            LOG.info(e);
                        }
                    }
                }
            });
        }

        public void setTerminationCallback(Consumer<Integer> r) {
            this.myTerminationCallback.offer(r);
        }
    }

    private static class ExecutorServiceHolder {
        private static final ExecutorService ourThreadExecutorsService = ExecutorServiceHolder.createServiceImpl();

        private ExecutorServiceHolder() {
        }

        private static ThreadPoolExecutor createServiceImpl() {
            return new ThreadPoolExecutor(10, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "OSProcessHandler pooled thread");
                }
            });
        }
    }
}

