/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.core;

import java.io.File;
import org.jetbrains.jet.internal.com.intellij.codeInsight.runner.JavaMainMethodProvider;
import org.jetbrains.jet.internal.com.intellij.core.CoreEnvironment;
import org.jetbrains.jet.internal.com.intellij.core.CoreJavaDirectoryService;
import org.jetbrains.jet.internal.com.intellij.core.CoreJavaFileManager;
import org.jetbrains.jet.internal.com.intellij.core.CoreJavaPsiImplementationHelper;
import org.jetbrains.jet.internal.com.intellij.core.CoreLanguageLevelProjectExtension;
import org.jetbrains.jet.internal.com.intellij.core.CorePsiPackageImplementationHelper;
import org.jetbrains.jet.internal.com.intellij.ide.highlighter.JavaClassFileType;
import org.jetbrains.jet.internal.com.intellij.ide.highlighter.JavaFileType;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageASTFactory;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaParserDefinition;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.PackageIndex;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.ClassFileViewProviderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.EmptySubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.FileTypeFileViewProviders;
import org.jetbrains.jet.internal.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFinder;
import org.jetbrains.jet.internal.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.jet.internal.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.jet.internal.com.intellij.psi.impl.EmptySubstitutorImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.JavaPsiFacadeImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiElementFactoryImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClassFileStubBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsStubBuilderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.DefaultClsStubBuilderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CoreJavaASTFactory;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.BinaryFileStubBuilders;

public class JavaCoreEnvironment
extends CoreEnvironment {
    private final CoreJavaFileManager myFileManager;

    public JavaCoreEnvironment(Disposable parentDisposable) {
        super(parentDisposable);
        this.registerFileType(JavaClassFileType.INSTANCE, "class");
        this.addExplicitExtension(FileTypeFileViewProviders.INSTANCE, JavaClassFileType.INSTANCE, new ClassFileViewProviderFactory());
        this.addExplicitExtension(BinaryFileStubBuilders.INSTANCE, JavaClassFileType.INSTANCE, new ClassFileStubBuilder());
        this.registerFileType(JavaFileType.INSTANCE, "java");
        this.addExplicitExtension(LanguageASTFactory.INSTANCE, JavaLanguage.INSTANCE, new CoreJavaASTFactory());
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, JavaLanguage.INSTANCE, new JavaParserDefinition());
        this.registerProjectExtensionPoint(PsiElementFinder.EP_NAME, PsiElementFinder.class);
        this.registerExtensionPoint(Extensions.getRootArea(), ClsStubBuilderFactory.EP_NAME, ClsStubBuilderFactory.class);
        this.registerExtensionPoint(Extensions.getRootArea(), PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
        this.registerExtensionPoint(Extensions.getRootArea(), JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
        this.addExtension(ClsStubBuilderFactory.EP_NAME, new DefaultClsStubBuilderFactory());
        this.myApplication.registerService(PsiPackageImplementationHelper.class, new CorePsiPackageImplementationHelper());
        this.myFileManager = new CoreJavaFileManager(this.myPsiManager, this.getLocalFileSystem(), this.myJarFileSystem);
        this.myProject.registerService(PsiElementFactory.class, new PsiElementFactoryImpl(this.myPsiManager));
        this.myProject.registerService(JavaPsiImplementationHelper.class, new CoreJavaPsiImplementationHelper());
        this.myProject.registerService(PsiResolveHelper.class, new PsiResolveHelperImpl(this.myPsiManager));
        this.myProject.registerService(LanguageLevelProjectExtension.class, new CoreLanguageLevelProjectExtension());
        this.myProject.registerService(PackageIndex.class, this.myFileManager);
        this.myProject.registerService(JavaResolveCache.class, new JavaResolveCache(null));
        JavaPsiFacadeImpl javaPsiFacade = new JavaPsiFacadeImpl(this.myProject, this.myPsiManager, this.myFileManager, null);
        this.myProject.registerService(CoreJavaFileManager.class, this.myFileManager);
        this.registerComponentInstance(this.myProject.getPicoContainer(), JavaPsiFacade.class, javaPsiFacade);
        this.myProject.registerService(JavaPsiFacade.class, javaPsiFacade);
        this.myApplication.registerService(EmptySubstitutor.class, new EmptySubstitutorImpl());
        this.myApplication.registerService(JavaDirectoryService.class, new CoreJavaDirectoryService());
    }

    public void addToClasspath(File path) {
        VirtualFile root;
        VirtualFile virtualFile = root = path.isFile() ? this.myJarFileSystem.findFileByPath(path + "!/") : this.getLocalFileSystem().findFileByPath(path.getPath());
        if (root == null) {
            throw new IllegalArgumentException("trying to add non-existing file to classpath: " + path);
        }
        this.myFileManager.addToClasspath(path);
        this.myFileIndexFacade.addLibraryRoot(root);
    }
}

