/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.core;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.core.CoreJavaFileManager;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public class CoreJavaDirectoryService
extends JavaDirectoryService {
    private static final Logger LOG = Logger.getInstance("#com.intellij.core.CoreJavaDirectoryService");

    @Override
    public PsiPackage getPackage(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.getPackage must not be null");
        }
        return ServiceManager.getService(dir.getProject(), CoreJavaFileManager.class).getPackage(dir);
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.getClasses must not be null");
        }
        LOG.assertTrue(dir.isValid());
        ArrayList classes = null;
        for (PsiFile file : dir.getFiles()) {
            PsiClass[] psiClasses;
            if (!(file instanceof PsiClassOwner) || file.getViewProvider().getLanguages().size() != 1 || (psiClasses = ((PsiClassOwner)file).getClasses()).length == 0) continue;
            if (classes == null) {
                classes = new ArrayList();
            }
            ContainerUtil.addAll(classes, psiClasses);
        }
        PsiClass[] psiClassArray = classes == null ? PsiClass.EMPTY_ARRAY : classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/core/CoreJavaDirectoryService.getClasses must not return null");
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createClass must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createClass must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createClass must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createClass must not be null");
        }
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createClass must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createClass must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createClass must not be null");
        }
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createClass must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkCreateClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.checkCreateClass must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.checkCreateClass must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiClass createInterface(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createInterface must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createInterface must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiClass createEnum(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createEnum must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createEnum must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiClass createAnnotationType(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createAnnotationType must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.createAnnotationType must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSourceRoot(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.isSourceRoot must not be null");
        }
        return false;
    }

    @Override
    public LanguageLevel getLanguageLevel(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaDirectoryService.getLanguageLevel must not be null");
        }
        return LanguageLevel.HIGHEST;
    }
}

