/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.UnknownFileType;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;

public class CoreFileTypeRegistry
extends FileTypeRegistry {
    private final Map<String, FileType> myExtensionsMap = new HashMap<String, FileType>();
    private final List<FileType> myAllFileTypes = new ArrayList<FileType>();

    public CoreFileTypeRegistry() {
        this.myAllFileTypes.add(UnknownFileType.INSTANCE);
    }

    @Override
    public boolean isFileIgnored(@NonNls @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreFileTypeRegistry.isFileIgnored must not be null");
        }
        return false;
    }

    @Override
    public FileType[] getRegisteredFileTypes() {
        return this.myAllFileTypes.toArray(new FileType[this.myAllFileTypes.size()]);
    }

    @Override
    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreFileTypeRegistry.getFileTypeByFile must not be null");
        }
        FileType fileType = this.getFileTypeByFileName(file.getName());
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/core/CoreFileTypeRegistry.getFileTypeByFile must not return null");
        }
        return fileType;
    }

    @Override
    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreFileTypeRegistry.getFileTypeByFileName must not be null");
        }
        String extension = FileUtil.getExtension(fileName);
        FileType result = this.myExtensionsMap.get(extension);
        FileType fileType = result == null ? UnknownFileType.INSTANCE : result;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/core/CoreFileTypeRegistry.getFileTypeByFileName must not return null");
        }
        return fileType;
    }

    public void registerFileType(FileType fileType, String extension) {
        this.myAllFileTypes.add(fileType);
        this.myExtensionsMap.put(extension, fileType);
    }

    @Override
    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreFileTypeRegistry.detectFileTypeFromContent must not be null");
        }
        FileType fileType = UnknownFileType.INSTANCE;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/core/CoreFileTypeRegistry.detectFileTypeFromContent must not return null");
        }
        return fileType;
    }
}

