/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.core.CoreASTFactory;
import org.jetbrains.jet.internal.com.intellij.core.CoreEncodingRegistry;
import org.jetbrains.jet.internal.com.intellij.core.CoreFileTypeRegistry;
import org.jetbrains.jet.internal.com.intellij.core.CoreProjectScopeBuilder;
import org.jetbrains.jet.internal.com.intellij.lang.DefaultASTFactory;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageExtension;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.jet.internal.com.intellij.lang.impl.PsiBuilderFactoryImpl;
import org.jetbrains.jet.internal.com.intellij.mock.MockApplication;
import org.jetbrains.jet.internal.com.intellij.mock.MockDumbService;
import org.jetbrains.jet.internal.com.intellij.mock.MockFileDocumentManagerImpl;
import org.jetbrains.jet.internal.com.intellij.mock.MockFileIndexFacade;
import org.jetbrains.jet.internal.com.intellij.mock.MockProject;
import org.jetbrains.jet.internal.com.intellij.mock.MockReferenceProvidersRegistry;
import org.jetbrains.jet.internal.com.intellij.mock.MockResolveScopeManager;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ModalityState;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.Document;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.impl.DocumentImpl;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.jet.internal.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileTypeExtension;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DumbService;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.StaticGetter;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.encoding.EncodingRegistry;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.FileSystemPersistence;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiCachedValuesFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiFileFactoryImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiModificationTrackerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.PsiDirectoryFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.PsiDirectoryFactoryImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.impl.FileManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import org.jetbrains.jet.internal.com.intellij.psi.search.ProjectScopeBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.CoreStubTreeLoader;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubTreeLoader;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.util.CachedValuesManagerImpl;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.messages.impl.MessageBusImpl;
import org.jetbrains.jet.internal.org.picocontainer.MutablePicoContainer;

public class CoreEnvironment {
    private final CoreFileTypeRegistry myFileTypeRegistry;
    private final CoreEncodingRegistry myEncodingRegistry;
    protected final MockApplication myApplication;
    protected MockProject myProject;
    private final CoreLocalFileSystem myLocalFileSystem;
    protected final CoreJarFileSystem myJarFileSystem;
    protected final MockFileIndexFacade myFileIndexFacade;
    protected final PsiManagerImpl myPsiManager;

    public CoreEnvironment(Disposable parentDisposable) {
        Extensions.cleanRootArea(parentDisposable);
        this.myFileTypeRegistry = new CoreFileTypeRegistry();
        this.myEncodingRegistry = new CoreEncodingRegistry();
        this.myApplication = new MockApplication(parentDisposable);
        ApplicationManager.setApplication(this.myApplication, new StaticGetter<FileTypeRegistry>(this.myFileTypeRegistry), new StaticGetter<EncodingRegistry>(this.myEncodingRegistry), parentDisposable);
        this.myLocalFileSystem = new CoreLocalFileSystem();
        this.myJarFileSystem = new CoreJarFileSystem();
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        this.myProject = new MockProject(this.myApplication.getPicoContainer(), parentDisposable);
        MutablePicoContainer appContainer = this.myApplication.getPicoContainer();
        this.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl(new Function<CharSequence, Document>(){

            @Override
            public Document fun(CharSequence charSequence) {
                return new DocumentImpl(charSequence);
            }
        }, null));
        this.registerComponentInstance(appContainer, VirtualFileManager.class, new VirtualFileManagerImpl(new VirtualFileSystem[]{this.myLocalFileSystem, this.myJarFileSystem}, new MessageBusImpl(this.myApplication, null), new FileSystemPersistence(){

            @Override
            public void refresh(boolean asynchronous, Runnable postAction, @NotNull ModalityState modalityState) {
                if (modalityState == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/core/CoreEnvironment$2.refresh must not be null");
                }
            }

            @Override
            public int getCheapFileSystemModificationCount() {
                return 0;
            }
        }));
        this.myApplication.registerService(DefaultASTFactory.class, new CoreASTFactory());
        this.myApplication.registerService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.myApplication.registerService(ReferenceProvidersRegistry.class, new MockReferenceProvidersRegistry());
        this.myApplication.registerService(StubTreeLoader.class, new CoreStubTreeLoader());
        this.registerExtensionPoint(Extensions.getRootArea(), ContentBasedFileSubstitutor.EP_NAME, ContentBasedFileSubstitutor.class);
        this.registerExtensionPoint(Extensions.getRootArea(), "org.jetbrains.jet.internal.com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
        this.myFileIndexFacade = new MockFileIndexFacade(this.myProject);
        MutablePicoContainer projectContainer = this.myProject.getPicoContainer();
        PsiModificationTrackerImpl modificationTracker = new PsiModificationTrackerImpl(this.myProject);
        this.myProject.registerService(PsiModificationTracker.class, modificationTracker);
        this.myProject.registerService(FileIndexFacade.class, this.myFileIndexFacade);
        this.myProject.registerService(ResolveScopeManager.class, new MockResolveScopeManager(this.myProject));
        this.myProject.registerService(ResolveCache.class, new ResolveCache(null));
        this.registerProjectExtensionPoint(PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
        this.myPsiManager = new PsiManagerImpl(this.myProject, null, null, this.myFileIndexFacade, null, modificationTracker);
        ((FileManagerImpl)this.myPsiManager.getFileManager()).markInitialized();
        this.registerComponentInstance(projectContainer, PsiManager.class, this.myPsiManager);
        this.myProject.registerService(PsiFileFactory.class, new PsiFileFactoryImpl(this.myPsiManager));
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myPsiManager)));
        this.myProject.registerService(PsiDirectoryFactory.class, new PsiDirectoryFactoryImpl(this.myPsiManager));
        this.myProject.registerService(ProjectScopeBuilder.class, new CoreProjectScopeBuilder(this.myProject, this.myFileIndexFacade));
        this.myProject.registerService(DumbService.class, new MockDumbService(this.myProject));
    }

    public Project getProject() {
        return this.myProject;
    }

    public void registerFileType(FileType fileType, String extension) {
        this.myFileTypeRegistry.registerFileType(fileType, extension);
    }

    public void registerParserDefinition(ParserDefinition definition) {
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), definition);
    }

    protected <T> void registerComponentInstance(MutablePicoContainer container, Class<T> key, T implementation) {
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }

    protected <T> void addExplicitExtension(final LanguageExtension<T> instance, final Language language, final T object) {
        instance.addExplicitExtension(language, object);
        Disposer.register(this.myProject, new Disposable(){

            @Override
            public void dispose() {
                instance.removeExplicitExtension(language, object);
            }
        });
    }

    protected <T> void addExplicitExtension(final FileTypeExtension<T> instance, final FileType fileType, final T object) {
        instance.addExplicitExtension(fileType, object);
        Disposer.register(this.myProject, new Disposable(){

            @Override
            public void dispose() {
                instance.removeExplicitExtension(fileType, object);
            }
        });
    }

    protected <T> void addExtension(ExtensionPointName<T> name, final T extension) {
        final ExtensionPoint<T> extensionPoint = Extensions.getRootArea().getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register(this.myProject, new Disposable(){

            @Override
            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    protected <T> void registerExtensionPoint(ExtensionsArea area, ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        String name = extensionPointName.getName();
        this.registerExtensionPoint(area, name, aClass);
    }

    protected <T> void registerExtensionPoint(ExtensionsArea area, String name, Class<? extends T> aClass) {
        if (!area.hasExtensionPoint(name)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name, aClass.getName(), kind);
        }
    }

    protected <T> void registerProjectExtensionPoint(ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        this.registerExtensionPoint(Extensions.getArea(this.myProject), extensionPointName, aClass);
    }

    public CoreLocalFileSystem getLocalFileSystem() {
        return this.myLocalFileSystem;
    }

    public CoreJarFileSystem getJarFileSystem() {
        return this.myJarFileSystem;
    }

    public void addLibraryRoot(VirtualFile file) {
        this.myFileIndexFacade.addLibraryRoot(file);
    }
}

