/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTFactory;
import org.jetbrains.jet.internal.com.intellij.lang.DefaultASTFactory;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.PsiCoreCommentImpl;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.ILazyParseableElementType;

public class CoreASTFactory
extends ASTFactory
implements DefaultASTFactory {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        LazyParseableElement lazyParseableElement;
        if (type instanceof IFileElementType) {
            lazyParseableElement = new FileElement(type, text);
            if (lazyParseableElement == null) throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createLazy must not return null");
            return lazyParseableElement;
        }
        lazyParseableElement = new LazyParseableElement(type, text);
        if (lazyParseableElement != null) return lazyParseableElement;
        throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createLazy must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CompositeElement createComposite(IElementType type) {
        CompositeElement compositeElement;
        if (type instanceof IFileElementType) {
            compositeElement = new FileElement(type, null);
            if (compositeElement == null) throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createComposite must not return null");
            return compositeElement;
        }
        compositeElement = new CompositeElement(type);
        if (compositeElement != null) return compositeElement;
        throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createComposite must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public LeafElement createLeaf(IElementType type, CharSequence text) {
        LeafElement leafElement;
        Language lang = type.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null && parserDefinition.getCommentTokens().contains(type)) {
            leafElement = this.createComment(type, text);
            if (leafElement == null) throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createLeaf must not return null");
            return leafElement;
        }
        leafElement = new LeafPsiElement(type, text);
        if (leafElement != null) return leafElement;
        throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createLeaf must not return null");
    }

    @Override
    public LeafElement createComment(IElementType type, CharSequence text) {
        return new PsiCoreCommentImpl(type, text);
    }
}

