/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.codeInsight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Computable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.NullableComputable;
import org.jetbrains.jet.internal.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCatchSection;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNewExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiResourceVariable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiThrowStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTryStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.AnalysisCanceledException;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ControlFlow;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ControlFlowFactory;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ControlFlowUtil;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.ProjectScope;
import org.jetbrains.jet.internal.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.jet.internal.com.intellij.util.NullableFunction;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.jet.internal.gnu.trove.THashSet;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not be null");
        }
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiClassType> getThrownCheckedExceptions(@NotNull PsiElement[] elements) {
        List<PsiClassType> list;
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getThrownCheckedExceptions must not be null");
        }
        List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(elements);
        if (exceptions.isEmpty()) {
            list = exceptions;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownCheckedExceptions must not return null");
            return list;
        }
        list = exceptions = ExceptionUtil.filterOutUncheckedExceptions(exceptions);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownCheckedExceptions must not return null");
    }

    @NotNull
    private static List<PsiClassType> filterOutUncheckedExceptions(List<PsiClassType> exceptions) {
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        for (PsiClassType exception : exceptions) {
            if (ExceptionUtil.isUncheckedException(exception)) continue;
            array.add(exception);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.filterOutUncheckedExceptions must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement element) {
        PsiCodeBlock[] catchBlocks;
        PsiParameter[] parameters;
        List<PsiClassType> list;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not be null");
        }
        if (element instanceof PsiClass) {
            PsiExpressionList argumentList;
            if (!(element instanceof PsiAnonymousClass && (argumentList = ((PsiAnonymousClass)element).getArgumentList()) != null ? (list = ExceptionUtil.getThrownExceptions(argumentList)) != null : (list = Collections.emptyList()) != null)) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodRef = ((PsiMethodCallExpression)element).getMethodExpression();
            JavaResolveResult result = methodRef.advancedResolve(false);
            list = ExceptionUtil.getExceptionsByMethodAndChildren(element, result);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiNewExpression) {
            JavaResolveResult result = ((PsiNewExpression)element).resolveMethodGenerics();
            list = ExceptionUtil.getExceptionsByMethodAndChildren(element, result);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiThrowStatement) {
            PsiExpression expr = ((PsiThrowStatement)element).getException();
            if (expr == null) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
                return list;
            } else {
                List<PsiType> types = ExceptionUtil.getPreciseThrowTypes(expr);
                List<PsiClassType> classTypes = ContainerUtil.mapNotNull(types, new NullableFunction<PsiType, PsiClassType>(){

                    @Override
                    public PsiClassType fun(PsiType type) {
                        return type instanceof PsiClassType ? (PsiClassType)type : null;
                    }
                });
                ExceptionUtil.addExceptions(classTypes, ExceptionUtil.getThrownExceptions(expr));
                list = classTypes;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
                return list;
            }
        }
        if (!(element instanceof PsiTryStatement)) {
            list = ExceptionUtil.getThrownExceptions(element.getChildren());
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)element;
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        if (tryBlock != null) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(tryBlock);
            array.addAll(exceptions);
        }
        for (PsiParameter parameter : parameters = tryStatement.getCatchBlockParameters()) {
            PsiType exception = parameter.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom(exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(catchBlock));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> thrownExceptions = ExceptionUtil.getThrownExceptions(finallyBlock);
                if ((completionReasons & 1) == 0) {
                    array = new ArrayList<PsiClassType>(thrownExceptions);
                } else {
                    ExceptionUtil.addExceptions(array, thrownExceptions);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        if ((list = array) == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
        return list;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethodAndChildren(PsiElement element, JavaResolveResult resolveResult) {
        PsiElement[] children;
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        if (method != null) {
            PsiClassType[] referenceTypes;
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (PsiType type : referenceTypes = method.getThrowsList().getReferencedTypes()) {
                if (!((type = substitutor.substitute(type)) instanceof PsiClassType)) continue;
                result.add((PsiClassType)type);
            }
        }
        for (PsiElement child : children = element.getChildren()) {
            ExceptionUtil.addExceptions(result, ExceptionUtil.getThrownExceptions(child));
        }
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getExceptionsByMethodAndChildren must not return null");
        }
        return arrayList;
    }

    private static void addExceptions(List<PsiClassType> array, Collection<PsiClassType> exceptions) {
        for (PsiClassType exception : exceptions) {
            ExceptionUtil.addException(array, exception);
        }
    }

    private static void addException(List<PsiClassType> array, PsiClassType exception) {
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom(exception)) {
                return;
            }
            if (!exception.isAssignableFrom(exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not be null");
        }
        Set<PsiClassType> set = ExceptionUtil.collectUnhandledExceptions(element, topElement, null);
        Collection<Object> collection = set == null ? Collections.emptyList() : set;
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not return null");
        }
        return collection;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not be null");
        }
        Collection<PsiClassType> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression, topElement);
        } else if (element instanceof PsiThrowStatement) {
            PsiThrowStatement statement = (PsiThrowStatement)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
        } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
            PsiMethod constructor = (PsiMethod)element.getParent();
            PsiClass aClass = constructor.getContainingClass();
            PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
            PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
            HashSet<PsiClassType> unhandled = new HashSet<PsiClassType>();
            for (PsiMethod superConstructor : superConstructors) {
                PsiClassType[] exceptionTypes;
                if (superConstructor.hasModifierProperty("private") || superConstructor.getParameterList().getParametersCount() != 0) continue;
                for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                    if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.isHandled(element, exceptionType, topElement)) continue;
                    unhandled.add(exceptionType);
                }
                break;
            }
            if (aClass != null) {
                PsiClassInitializer[] initializers = aClass.getInitializers();
                THashSet<PsiClassType> thrownByInitializer = new THashSet<PsiClassType>();
                for (PsiClassInitializer initializer : initializers) {
                    if (initializer.hasModifierProperty("static")) continue;
                    thrownByInitializer.clear();
                    ExceptionUtil.collectUnhandledExceptions(initializer.getBody(), initializer, thrownByInitializer);
                    for (PsiClassType thrown : thrownByInitializer) {
                        if (ExceptionUtil.isHandled(constructor.getBody(), thrown, topElement)) continue;
                        unhandled.add(thrown);
                    }
                }
            }
            unhandledExceptions = unhandled;
        }
        if (element instanceof PsiResourceVariable) {
            List<PsiClassType> unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceVariable)element, topElement);
            if (unhandledExceptions == null) {
                unhandledExceptions = unhandled;
            } else {
                unhandledExceptions.addAll(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet<PsiClassType>();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            foundExceptions = ExceptionUtil.collectUnhandledExceptions(child, topElement, foundExceptions);
        }
        return foundExceptions;
    }

    private static boolean firstStatementIsConstructorCall(PsiCodeBlock constructorBody) {
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiElement[] elements) {
        final ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitCallExpression(PsiCallExpression expression) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                this.visitElement(expression);
            }

            @Override
            public void visitThrowStatement(PsiThrowStatement statement) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(statement, null));
                this.visitElement(statement);
            }

            @Override
            public void visitResourceVariable(PsiResourceVariable resourceVariable) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(resourceVariable, null));
                this.visitElement(resourceVariable);
            }
        };
        for (PsiElement element : elements) {
            element.accept(visitor);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiElement element) {
        List<PsiClassType> list;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            list = ExceptionUtil.getUnhandledExceptions(expression, null);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        }
        if (element instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)element;
            list = ExceptionUtil.getUnhandledExceptions(throwStatement, null);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        }
        if (element instanceof PsiResourceVariable) {
            list = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceVariable)element, null);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        }
        list = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{element});
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        final JavaResolveResult result = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = ApplicationManager.getApplication().runReadAction(new Computable<PsiSubstitutor>(){

            @Override
            public PsiSubstitutor compute() {
                return result.getSubstitutor();
            }
        });
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(method, methodCall, topElement, substitutor);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiResourceVariable resource, @Nullable PsiElement topElement) {
        List<PsiClassType> list;
        PsiMethod[] methods;
        Project project = resource.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiClass autoCloseable = facade.findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope(project));
        if (autoCloseable != null && (methods = autoCloseable.findMethodsByName("close", false)).length == 1) {
            PsiMethod method;
            PsiClass resourceClass;
            MethodSignature signature = methods[0].getSignature(PsiSubstitutor.EMPTY);
            PsiType resourceType = resource.getType();
            if (resourceType instanceof PsiClassType && (resourceClass = ((PsiClassType)resourceType).resolve()) != null && (method = MethodSignatureUtil.findMethodBySignature(resourceClass, signature, true)) != null) {
                list = ExceptionUtil.getUnhandledExceptions(method, resource, topElement, PsiSubstitutor.EMPTY);
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledCloserExceptions must not return null");
                return list;
            }
        }
        if ((list = Collections.emptyList()) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledCloserExceptions must not return null");
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final PsiThrowStatement throwStatement, final @Nullable PsiElement topElement) {
        PsiExpression exception = throwStatement.getException();
        List<PsiType> types = ExceptionUtil.getPreciseThrowTypes(exception);
        List<PsiClassType> list = ContainerUtil.mapNotNull(types, new NullableFunction<PsiType, PsiClassType>(){

            @Override
            public PsiClassType fun(PsiType type) {
                PsiClassType classType;
                if (type instanceof PsiClassType && !ExceptionUtil.isUncheckedException(classType = (PsiClassType)type) && !ExceptionUtil.isHandled(throwStatement, classType, topElement)) {
                    return classType;
                }
                return null;
            }
        });
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression) {
        PsiType type;
        List<PsiType> list;
        PsiElement target;
        if (expression instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression).resolve()) != null && PsiUtil.isCatchParameter(target)) {
            list = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getPreciseThrowTypes must not return null");
            return list;
        }
        if (expression != null && (type = expression.getType()) != null) {
            list = Arrays.asList(type);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getPreciseThrowTypes must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getPreciseThrowTypes must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(PsiMethod method, PsiElement element, PsiElement topElement, PsiSubstitutor substitutor) {
        List<PsiClassType> list;
        if (method == null || ExceptionUtil.isArrayClone(method, element)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        } else {
            PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
            if (referencedTypes.length <= 0) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
                return list;
            } else {
                ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
                for (PsiClassType referencedType : referencedTypes) {
                    PsiType type = substitutor.substitute(referencedType);
                    if (!(type instanceof PsiClassType)) continue;
                    PsiClassType classType = (PsiClassType)type;
                    PsiClass exceptionClass = ((PsiClassType)type).resolve();
                    if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.isHandled(element, classType, topElement)) continue;
                    result.add((PsiClassType)type);
                }
                list = result;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
                return list;
            }
        }
    }

    private static boolean isArrayClone(PsiMethod method, PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        if (!method.getName().equals("clone")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(PsiClassType type) {
        final GlobalSearchScope searchScope = type.getResolveScope();
        final PsiClass aClass = type.resolve();
        if (aClass == null) {
            return false;
        }
        PsiClass runtimeExceptionClass = ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiClass>(){

            @Override
            public PsiClass compute() {
                return JavaPsiFacade.getInstance(aClass.getProject()).findClass("java.lang.RuntimeException", searchScope);
            }
        });
        if (runtimeExceptionClass != null && InheritanceUtil.isInheritorOrSelf(aClass, runtimeExceptionClass, true)) {
            return true;
        }
        PsiClass errorClass = ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiClass>(){

            @Override
            public PsiClass compute() {
                return JavaPsiFacade.getInstance(aClass.getProject()).findClass("java.lang.Error", searchScope);
            }
        });
        return errorClass != null && InheritanceUtil.isInheritorOrSelf(aClass, errorClass, true);
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.isUncheckedExceptionOrSuperclass must not be null");
        }
        return ExceptionUtil.isGeneralExceptionType(type) || ExceptionUtil.isUncheckedException(type);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.isGeneralExceptionType must not be null");
        }
        String canonicalText = type.getCanonicalText();
        return "java.lang.Throwable".equals(canonicalText) || "java.lang.Exception".equals(canonicalText);
    }

    public static boolean isHandled(PsiClassType exceptionType, PsiElement throwPlace) {
        return ExceptionUtil.isHandled(throwPlace, exceptionType, throwPlace.getContainingFile());
    }

    private static boolean isHandled(PsiElement element, PsiClassType exceptionType, PsiElement topElement) {
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType);
        }
        if (parent instanceof PsiClass) {
            return parent instanceof PsiAnonymousClass && ExceptionUtil.isHandled(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent).hasModifierProperty("static")) {
                return false;
            }
            if (!(parent.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent).getContainingClass();
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        } else if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else {
            PsiClass aClass;
            if (parent instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return exceptionHandler != null && exceptionHandler.isHandledException(exceptionType);
            }
            if (PsiImplUtil.isInServerPage(parent) && parent instanceof PsiFile) {
                return true;
            }
            if (parent instanceof PsiFile) {
                return false;
            }
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element && (aClass = ((PsiField)parent).getContainingClass()) != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent).hasModifierProperty("static")) {
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        }
        return ExceptionUtil.isHandled(parent, exceptionType, topElement);
    }

    private static boolean areAllConstructorsThrow(PsiClass aClass, PsiClassType exceptionType) {
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean thrown = constructors.length != 0;
        for (PsiMethod constructor : constructors) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    private static boolean isCaught(PsiTryStatement tryStatement, PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(PsiCodeBlock finallyBlock) {
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if ((completionReasons & 1) == 0) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(PsiMethod method, PsiClassType exceptionType) {
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes);
    }

    public static boolean isHandledBy(PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes) {
        if (referencedTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.isHandledBy must not be null");
        }
        for (PsiClassType classType : referencedTypes) {
            if (!classType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void sortExceptionsByHierarchy(List<PsiClassType> exceptions) {
        if (exceptions.size() <= 1) {
            return;
        }
        ExceptionUtil.sortExceptionsByHierarchy(exceptions.subList(1, exceptions.size()));
        for (int i = 0; i < exceptions.size() - 1; ++i) {
            if (!TypeConversionUtil.isAssignable(exceptions.get(i), exceptions.get(i + 1))) continue;
            Collections.swap(exceptions, i, i + 1);
        }
    }
}

